// =====================================================================
//  $Id: TRunInformationTable.cc,v 1.4 2004/03/07 10:30:34 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TRunInformationTable.cc,v $
//  Revision 1.4  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:45  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunInformationTable.hh"
#include "TRunInformation.hh"
#include "TOutputHtmlFileStream.hh"

TRunInformationTable::TRunInformationTable()
  : theRunInformationList()
{
  theRunInformationList.clear();
}

TRunInformationTable::TRunInformationTable( const TRunInformationList& infolist )
  : theRunInformationList( infolist )
{;}

TRunInformationTable::TRunInformationTable( const TRunInformationTable& right )
  : theRunInformationList( right.theRunInformationList )
{;}

TRunInformationTable::~TRunInformationTable()
{;}

const TRunInformationTable& TRunInformationTable::operator=( const TRunInformationTable& right )
{
  theRunInformationList = right.theRunInformationList;
  return *this;
}

Tbool TRunInformationTable::operator==( const TRunInformationTable& right ) const
{
  if ( theRunInformationList == right.theRunInformationList ) {
    return Ttrue;
  } else {
    return Tfalse;
  }
}

Tbool TRunInformationTable::operator!=( const TRunInformationTable& right ) const
{
  if ( theRunInformationList != right.theRunInformationList ) {
    return Ttrue;
  } else {
    return Tfalse;
  }
}

TRunInformationTable operator+( const TRunInformationList& left, const TRunInformationTable& right )
{
  TRunInformationTable table = left + right;
  return table;
}

TRunInformationTable operator+( const TRunInformation& left, const TRunInformationTable& right )
{
  TRunInformationTable table = left + right;
  return table;
}

TRunInformationTable TRunInformationTable::operator+( const TRunInformationTable& right ) const
{
  TRunInformationTable table( *this );
  const TRunInformationList infolist = right.GetRunInformationList();
  for ( Tsize_t i = 0; i < infolist.size(); i ++ ) {
    table.AddRunInformation( infolist[ i ] );
  }
  return table;
}

TRunInformationTable TRunInformationTable::operator+( const TRunInformationList& right ) const
{
  TRunInformationTable table( *this );
  for ( Tsize_t i = 0; i < right.size(); i ++ ) {
    table.AddRunInformation( right[ i ] );
  }
  return table;
}

TRunInformationTable TRunInformationTable::operator+( const TRunInformation& right ) const
{
  TRunInformationTable table( *this );
  table.AddRunInformation( right );
  return table;
}

TRunInformationTable& TRunInformationTable::operator+=( const TRunInformationTable& right )
{
  *this = *this + right;
  return *this;
}

TRunInformationTable& TRunInformationTable::operator+=( const TRunInformationList& right )
{
  *this = *this + right;
  return *this;
}

TRunInformationTable& TRunInformationTable::operator+=( const TRunInformation& right )
{
  *this = *this + right;
  return *this;
}

Tostream& operator<<( Tostream& tos, const TRunInformationTable& right )
{
  Tsize_t nrow = right.theRunInformationList.size();
  for ( Tsize_t i = 0; i < nrow; i ++ ) {
    tos << right.theRunInformationList[ i ];
    if ( i != nrow - 1 ) {
      tos << Tendl;
    }
  }
  return tos;
}

TOutputHtmlFileStream& operator<<( TOutputHtmlFileStream& html, const TRunInformationTable& right )
{
  if ( html.IsOpen() ) {
    if ( !html.OpenTable() ) {
      html.OpenTable();
    }
    for ( Tsize_t i = 0; i < right.theRunInformationList.size(); i ++ ) {
      html << "<tr><td><b>" << right.theRunInformationList[ i ].GetItem() << "</b></td>" << Tflush;
      html << "<td>" << right.theRunInformationList[ i ].GetValue() << "</td></tr>" << Tendl;
    }
    if ( !html.CloseTable() ) {
      html.CloseTable();
    }
  }
  return html;
}

Tint TRunInformationTable::GetNumberOfRows() const
{
  return (Tint)theRunInformationList.size();
}

Tvoid TRunInformationTable::SetRunInformation( const Tstring& item )
{
  if ( !HasItem( item ) ) {
    AddRunInformation( item );
    return;
  }
  SetInformation( theRunInformationList[ FindItem( item ) ] );
  return;
}

Tvoid TRunInformationTable::SetRunInformation( const Tstring& item, const Tstring& value )
{
  if ( !HasItem( item ) ) {
    AddRunInformation( item, value );
    return;
  }
  theRunInformationList[ FindItem( item ) ].SetValue( value );
  return;
}

Tvoid TRunInformationTable::SetRunInformation( const TRunInformation& runinfo )
{
  Tstring item = runinfo.GetItem();
  if ( !HasItem( item ) ) {
    AddRunInformation( runinfo );
    return;
  }
  theRunInformationList[ FindItem( item ) ] = runinfo;
  return;
}

Tvoid TRunInformationTable::SetRunInformation()
{
  for ( Tsize_t i = 0; i < theRunInformationList.size(); i ++ ) {
    SetInformation( theRunInformationList[ i ] );
  }
  return;
}

Tvoid TRunInformationTable::AddRunInformation( const Tstring& item )
{
  if ( HasItem( item ) ) {
    Tstring head = "TRunInformationTable::AddRunInformation: ";
    Tcerr << head << item << " already exist." << Tendl;
    return;
  }
  TRunInformation runinfo( item );
  theRunInformationList.push_back( runinfo );
  return;
}

Tvoid TRunInformationTable::AddRunInformation( const Tstring& item, const Tstring& value )
{
  if ( HasItem( item ) ) {
    Tstring head = "TRunInformationTable::AddRunInformation: ";
    Tcerr << head << item << " already exist." << Tendl;
    return;
  }
  TRunInformation runinfo( item, value );
  theRunInformationList.push_back( runinfo );
  return;
}

Tvoid TRunInformationTable::AddRunInformation( const TRunInformation& runinfo )
{
  Tstring item = runinfo.GetItem();
  if ( HasItem( item ) ) {
    Tstring head = "TRunInformationTable::AddRunInformation: ";
    Tcerr << head << item << " already exist." << Tendl;
    return;
  }
  theRunInformationList.push_back( runinfo );
  return;
}

Tvoid TRunInformationTable::AddRunInformation()
{
  TRunInformation runinfo;
  SetInformation( runinfo );
  return;
}

Tstring TRunInformationTable::GetItem( const Tstring& value ) const
{
  Tstring retitem = "";
  Tint pos = FindValue( value );
  if ( pos >= 0 && pos < (Tint)theRunInformationList.size() ) {
    retitem = theRunInformationList[ pos ].GetItem();
  } else {
    Tstring head = "TRunInformationTable::GetItem: ";
    Tcerr << head << value << " doesn't exist." << Tendl;
  }
  return retitem;
}

Tstring TRunInformationTable::GetItem( Tint nrow ) const
{
  Tstring retitem = "";
  if ( nrow >= 0 && nrow < (Tint)theRunInformationList.size() ) {
    retitem = theRunInformationList[ nrow ].GetItem();
  }
  return retitem;
}

Tstring TRunInformationTable::GetValue( const Tstring& item ) const
{
  Tstring retval = "";
  Tint pos = FindItem( item );
  if ( pos >= 0 && pos < (Tint)theRunInformationList.size() ) {
    retval = theRunInformationList[ pos ].GetValue();
  } else {
    Tstring head = "TRunInformationTable::GetValue: ";
    Tcerr << head << item << " doesn't exist." << Tendl;
  }
  return retval;
}

Tstring TRunInformationTable::GetValue( Tint nrow ) const
{
  Tstring retval = "";
  if ( nrow >= 0 && nrow < (Tint)theRunInformationList.size() ) {
    retval = theRunInformationList[ nrow ].GetValue();
  }
  return retval;
}

Tint TRunInformationTable::FindItem( const Tstring& item ) const
{
  for ( Tint i = 0; i < (Tint)theRunInformationList.size(); i ++ ) {
    if ( theRunInformationList[ i ].GetItem() == item ) {
      return i;
    }
  }
  return tNotFound;
}

Tint TRunInformationTable::FindValue( const Tstring& value ) const
{
  for ( Tint i = 0; i < (Tint)theRunInformationList.size(); i ++ ) {
    if ( theRunInformationList[ i ].GetValue() == value ) {
      return i;
    }
  }
  return tNotFound;
}

Tint TRunInformationTable::FindRunInformation( const TRunInformation& runinfo ) const
{
  for ( Tint i = 0; i < (Tint)theRunInformationList.size(); i ++ ) {
    if ( theRunInformationList[ i ] == runinfo ) {
      return i;
    }
  }
  return tNotFound;
}

Tbool TRunInformationTable::HasItem( const Tstring& item ) const
{
  if ( FindItem( item ) == tNotFound ) {
    return Tfalse;
  }
  return Ttrue;
}

Tbool TRunInformationTable::HasRunInformation( const TRunInformation& runinfo ) const
{
  if ( FindRunInformation( runinfo ) == tNotFound ) {
    return Tfalse;
  }
  return Ttrue;
}

Tvoid TRunInformationTable::Remove( const Tstring& item )
{
  if ( !HasItem( item ) ) {
    Tstring head = "TRunInformationTable::Remove: ";
    Tcerr << head << item << " doesn't exist." << Tendl;
    return;
  }
  theRunInformationList.erase( theRunInformationList.begin() + FindItem( item ) );
  return;
}

Tvoid TRunInformationTable::Remove( const TRunInformation& runinfo )
{
  if ( !HasRunInformation( runinfo ) ) {
    Tstring head = "TRunInformationTable::Remove: ";
    Tcerr << head << runinfo << " doesn't exist in the table." << Tendl;
    return;
  }
  theRunInformationList.erase( theRunInformationList.begin() + FindRunInformation( runinfo ) );
  return;
}

Tvoid TRunInformationTable::Clear()
{
  for ( Tsize_t i = 0; i < theRunInformationList.size(); i ++ ) {
    theRunInformationList[ i ].Clear();
  } 
  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TRunInformationTable)
#endif
