// =====================================================================
//  $Id: ifilterdump.cc,v 1.1 2003/12/06 11:04:58 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: ifilterdump.cc,v $
//  Revision 1.1  2003/12/06 11:04:58  goiwai
//  ե륿̤¸ǡ쥳ɤɤߤߤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"
#include "TArgument.hh"
#include "TDecompressObjectFilter.hh"

int main( int argc, char** argv, char** envv )
{
  TArgument arg( argc, argv );
  if ( arg.GetNumberOfElements() != 1 || !isexist( arg[ 0 ] ) ) {
    arg.ShowUsage();
  }
  const Tstring filename = arg[ 0 ];

  TDecompressObjectFilter filter;
  TInputObjectFile ifile( &filter, filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ifile >> record ) {
    Tcout << record << Tendl;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifile.GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  return 0;
}
