// =====================================================================
//  $Id: rs01OFFvdcdump.cc,v 1.2 2003/10/06 16:28:15 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: rs01OFFvdcdump.cc,v $
//  Revision 1.2  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.1  2003/09/17 09:27:01  goiwai
//  ٥ȤȤξͥʬϤޤ.
//  γפ򤹤ΤǤ.
//  Ϥ
//    ٥ID
//    ͥID
//    
//    ɤ߽ФŰ(ڥǥϹθʤ)
//    ľΥ٥Ȥηв
//  Ǥ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"

static const Tstring rcpath = "rs01setup";

TInputObjectFile* ifile = 0;
TEnvironmentVariableTable* envtable = 0;
TDataRecord record;
TDataElement element;

static Tvoid initialize( Tint argc, Tchar** argv );
static Tvoid event();
static Tvoid runbegin();
static Tvoid runend();

int main( int argc, char** argv, char** envv )
{
  initialize( argc, argv );
  while ( ifile -> Read( record ) ) {
    Tstring recid = record.GetID();
    if ( recid == "RUN BEGIN" ) {
      runbegin();
      continue;
    } else if ( recid == "EVENT" ) {
      event();
    } else if ( recid == "RUN END" ) {
      runend();
      break;
    } else {
      Tcerr << "unknown tag: " << recid << Tendl;
      break;
    }
  }
  return 0;
}

Tvoid initialize( Tint argc, Tchar** argv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <run#>" << Tendl;
    exit( -1 );
  }

  Tint runid = (Tint)strtol( argv[ 1 ], 0, 0 );
  Tstring runidstr = itostr( runid );

  envtable = new TEnvironmentVariableTable ( rcpath );
  Tstring rechead = envtable -> GetEnvironmentValue( "RS01_RECORD_HEAD" );
  Tstring recpath = envtable -> GetEnvironmentValue( "RS01_RECORD_DIR" );
  Tstring fpath = recpath + Tslash + rechead + runidstr + ".drec";
  ifile = new TInputObjectFile( fpath );

  return;
}

Tvoid event()
{
  static const Tint npin = 32;
  Tint eventid;
  record[0][0][0].StorePrimitive(eventid);

  Tdouble vdcbuf;
  Tstring datebuf;
  Tdouble timebuf;
  Tdouble timesumbuf;

  for ( Tint ch = 0; ch < npin; ch ++ ) {
    record[1][ch][0].StorePrimitive(vdcbuf);
    record[1][ch][1].StorePrimitive(datebuf);
    record[1][ch][4].StorePrimitive(timebuf);
    record[1][ch][5].StorePrimitive(timesumbuf);

    Tcout << "EVENT: " << eventid << Ttab;
    Tcout << "CHANNEL: " << ch << Ttab;
    Tcout << "DATE: " << datebuf << Ttab;
    Tcout << "VDC: " << vdcbuf << Ttab;
    Tcout << "ELAPSED: " << timebuf << "(" << timesumbuf << ")" << Tendl;
  }

  return;
}

Tvoid runbegin()
{
  return;
}

Tvoid runend()
{
  return;
}
