// =====================================================================
//  $Id: rs01OFFvdcview3x3.cc,v 1.2 2003/10/06 16:28:15 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: rs01OFFvdcview3x3.cc,v $
//  Revision 1.2  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.1  2003/09/17 09:39:32  goiwai
//  ڥǥθʤɤ߽ФŰ(V) VS (H:M:S)ͥ16(
//  )Ȥμ8ͥΤߥץåȤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

static const Tstring rcpath = "rs01setup";
static const Tint npin = 32;
// static Tint pinpos[ npin ] = {
//            3,  4, 5,   6,  7,
//       10, 11, 12, 13, 14, 15, 16,
//   17, 18, 19, 20, 21, 22, 23, 24,
//       26, 27, 28, 29, 30, 31, 32,
//           35, 36, 37, 38, 39
// };

TInputObjectFile* ifile = 0;
TEnvironmentVariableTable* envtable = 0;
TDataRecord record;
TDataElement element;
Tdouble vdc[ npin ];
Tint elapsed[ npin ];
//
TApplication* theApplication = 0;
TCanvas* CVvdc = 0;
static const Tint nx = 3;
static const Tint ny = 3;
static const Tint npadvdc = nx * ny;
TH1D** H1Dvdc;

Tstring htvdc[ npin ];
Tstring hnamevdc[ npin ];
Tstring fpath, macrof, giff, psf, rootf;
static Tint modperiod;

static Tvoid initialize( Tint argc, Tchar** argv );
static Tvoid event();
static Tvoid runbegin();
static Tvoid runend();

int main( int argc, char** argv, char** envv )
{
  initialize( argc, argv );

  while ( ifile -> Read( record ) ) {
    Tstring recid = record.GetID();
    if ( recid == "RUN BEGIN" ) {
      runbegin();
      continue;
    } else if ( recid == "EVENT" ) {
      event();
    } else if ( recid == "RUN END" ) {
      runend();
      break;
    } else {
      Tcerr << "unknown tag: " << recid << Tendl;
      break;
    }
    gSystem -> ProcessEvents();
  }

  theApplication -> Terminate();
  return 0;
}

Tvoid initialize( Tint argc, Tchar** argv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <run#>" << Tendl;
    exit( -1 );
  }

  Tint runid = (Tint)strtol( argv[ 1 ], 0, 0 );
  Tstring runidstr = itostr( runid );

  envtable = new TEnvironmentVariableTable ( rcpath );
  Tstring rechead = envtable -> GetEnvironmentValue( "RS01_RECORD_HEAD" );
  Tstring recpath = envtable -> GetEnvironmentValue( "RS01_RECORD_DIR" );
  fpath = recpath + Tslash + rechead + runidstr + ".drec";
  ifile = new TInputObjectFile( fpath );

  rootf = rechead + runidstr + "vdc3x3.root";
  macrof = rechead + runidstr + "vdc3x3.C";
  giff = rechead + runidstr + "vdc3x3.gif";
  psf = rechead + runidstr + "vdc3x3.ps";

  modperiod = envtable -> GetIntegerValue( "RS01_UPDATE_PERIOD" );


  theApplication = rootinit();
  TGaxis::SetMaxDigits( 2 );


  // Ű VS  Х
  CVvdc = new TCanvas( "CVvdc", "VDC VS Time", 960, 720 );
  CVvdc -> ToggleEventStatus();
  CVvdc -> Divide( nx, ny );


  // Ű VS ֤ν
  H1Dvdc = new TH1D*[npin];
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    htvdc[ ch ] = "Channel: " + itostr( ch, 2 ) + ", Run ID: " + runidstr;
    hnamevdc[ ch ] = "H1Dvdc" + itostr( ch, 2 );

    H1Dvdc[ ch ] = 
      new TH1D( hnamevdc[ ch ].c_str(), htvdc[ ch ].c_str(), 10, 0.0, 10.0 );

    H1Dvdc[ ch ] -> SetStats( 0 );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTimeDisplay( 1 );
    H1Dvdc[ ch ] -> SetMarkerStyle( 1 );
    H1Dvdc[ ch ] -> SetLineColor( 10 );
    H1Dvdc[ ch ] -> SetLineStyle( 0 );
    H1Dvdc[ ch ] -> SetLineWidth( 0 );
    
    H1Dvdc[ ch ] -> GetXaxis() -> SetNdivisions( 504 );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTimeFormat( "%H:%M:%S" );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTitle( "Time (H:M:S)" );
    H1Dvdc[ ch ] -> GetXaxis() -> CenterTitle();

    H1Dvdc[ ch ] -> GetYaxis() -> SetTitle( "DC Voltage (V)" );
    H1Dvdc[ ch ] -> GetYaxis() -> SetNoExponent();
    H1Dvdc[ ch ] -> GetYaxis() -> CenterTitle();
  }


 //ɽΤ 7,8,9 15,16,17 22,23,24
  CVvdc -> cd( 1 );
  H1Dvdc[ 7 ] -> Draw("pe");
  CVvdc -> cd( 2 );
  H1Dvdc[ 8 ] -> Draw("pe");
  CVvdc -> cd( 3 );
  H1Dvdc[ 9 ] -> Draw("pe");
  CVvdc -> cd( 4 );
  H1Dvdc[ 15 ] -> Draw("pe");
  CVvdc -> cd( 5 );
  H1Dvdc[ 16 ] -> Draw("pe");
  CVvdc -> cd( 6 );
  H1Dvdc[ 17 ] -> Draw("pe");
  CVvdc -> cd( 7 );
  H1Dvdc[ 22 ] -> Draw("pe");
  CVvdc -> cd( 8 );
  H1Dvdc[ 23 ] -> Draw("pe");
  CVvdc -> cd( 9 );
  H1Dvdc[ 24 ] -> Draw("pe");

  return;
}

Tvoid event()
{
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    // VDCΥʥåץå
    element = record[ 1 ][ ch ][ 0 ];
    element.StorePrimitives( &vdc[ ch ] );

    // 󳫻Ϥηвÿ(sec)
    element = record[ 1 ][ ch ][ 3 ];
    element.StorePrimitives( &elapsed[ ch ] );

    //Ű VS 
    H1Dvdc[ ch ] -> SetBinContent( elapsed[ ch ], vdc[ ch ] );

    H1Dvdc[ ch ] -> GetXaxis() -> SetNdivisions( 504 );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTimeFormat( "%H:%M:%S" );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTitle( "Time (H:M:S)" );
    H1Dvdc[ ch ] -> GetXaxis() -> CenterTitle();
    H1Dvdc[ ch ] -> GetYaxis() -> SetTitle( "DC Voltage (V)" );
    H1Dvdc[ ch ] -> GetYaxis() -> SetNoExponent();
    H1Dvdc[ ch ] -> GetYaxis() -> CenterTitle();

    H1Dvdc[ ch ] -> SetDrawOption( "pe" );
  }



  // update
  element = record[ 0 ][ 0 ][ 0 ];
  Tint eventid;
  element.StorePrimitives( &eventid );
  if ( eventid % modperiod == 0 ) {
    for ( Tint i = 0; i < npadvdc; i ++ ) {
      CVvdc -> GetPad(i+1)->Modified();
      CVvdc -> GetPad(i+1)->Update();
    }
  }


  return;
}

Tvoid runbegin()
{
  element = record[ 0 ][ 1 ][ 1 ];
  Tint secbuf;
  element.StorePrimitives( &secbuf );
  gStyle -> SetTimeOffset( secbuf );
  return;
}

Tvoid runend()
{
  // update
  for ( Tint i = 0; i < npadvdc; i ++ ) {
    CVvdc -> GetPad(i+1)->Modified();
    CVvdc -> GetPad(i+1)->Update();
  }

  // printout
  CVvdc -> cd();

  TFile* file = new TFile( rootf.c_str(), "RECREATE", "VDC VIEW OFFLINE" );
  H1Dvdc[ 7 ] -> Write();
  H1Dvdc[ 8 ] -> Write();
  H1Dvdc[ 9 ] -> Write();
  H1Dvdc[ 15 ] -> Write();
  H1Dvdc[ 16 ] -> Write();
  H1Dvdc[ 17 ] -> Write();
  H1Dvdc[ 22 ] -> Write();
  H1Dvdc[ 23 ] -> Write();
  H1Dvdc[ 24 ] -> Write();
  CVvdc -> Write();
  file -> Close();


  CVvdc -> Print( giff.c_str() );
  CVvdc -> Print( psf.c_str() );

  return;
}
