// =====================================================================
//  $Id: Sw01EventAction.cc,v 1.2 2004/03/04 15:11:55 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: Sw01EventAction.cc,v $
//  Revision 1.2  2004/03/04 15:11:55  goiwai
//  ۤȤɤؿ̾ѹˤȤʤǤ
//
//  Revision 1.1  2004/03/01 09:48:29  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
//  Revision 1.3  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:15  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TEvent.hh"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"
#include "TEnvironmentVariableTable.hh"

#include "Sw01EventAction.hh"
#include "Sw01RunAction.hh"
#include "Sw01SystemAction.hh"
#include "Sw01EventDisplay.hh"

Sw01EventAction::Sw01EventAction()
{;}

Sw01EventAction::~Sw01EventAction()
{;}

TReadoutList* Sw01EventAction::WaitTrigger()
{
  TSoftwareInterruptRegisterModule* ir =
    (TSoftwareInterruptRegisterModule*)( theCrate -> GetModule( "Interrupt Register" ) );
  Tbool trigger = Tfalse;
  do {
    if ( ir -> ReadInterruptRegister() == 1 ) {
      trigger = Ttrue;
      break;
    }
  } while ( trigger == Tfalse );

  return theReadoutBook -> GetReadoutList( "EVENT" );
}

Tvoid Sw01EventAction::AtFirst( TEvent& anEvent )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint mask = envtable.GetIntegerValue( "SW01_INTERRUPT_MASK" );

  TSoftwareInterruptRegisterModule* ir =
    (TSoftwareInterruptRegisterModule*)( theCrate -> GetModule( "Interrupt Register" ) );
  ir -> SetInterruptMaskRegister( mask );

  return;
}

Tvoid Sw01EventAction::AtLast( TEvent& anEvent )
{
  Sw01RunAction* action =
    (Sw01RunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  *ofile << anEvent.GetDataRecord();

  theCrate -> GetModule( "Event ID" ) -> Update();
  theCrate -> GetModule( "Flash ADC" ) -> Update();
  theCrate -> GetModule( "ADC" ) -> Update();
  theCrate -> GetModule( "Geant4" ) -> Update();

  theCrate -> GetModule( "Interrupt Register" ) -> Clear();

  Sw01SystemAction* sysaction =
    (Sw01SystemAction*)( theRunManager->GetSystemAction() );
  Sw01EventDisplay* evd = sysaction -> GetEventDisplay();

  evd -> Fill( anEvent );
  evd -> Update();

  return;
}
