// =====================================================================
//  $Id: Sw01Geant4ViewCommand.cc,v 1.1 2004/03/01 09:48:29 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: Sw01Geant4ViewCommand.cc,v $
//  Revision 1.1  2004/03/01 09:48:29  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
//  Revision 1.3  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:15  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "Sw01Geant4ViewCommand.hh"
#include "Sw01RunAction.hh"

static const Tstring _name = "/local/sw01g4view";
static const Tstring _desc = "view Histogram(Geant4 MC Data)";

Sw01Geant4ViewCommand::Sw01Geant4ViewCommand()
  : TCommand( _name, _desc )
{;}

Sw01Geant4ViewCommand::~Sw01Geant4ViewCommand()
{;}

Tvoid Sw01Geant4ViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "SW01_BIN_DIR" );
  Tstring comname = bindir + Tslash + "sw01g4view";

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Sw01RunAction* action = (Sw01RunAction*)( theRunManager -> GetRunAction() );
  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( comname );
  args.push_back( filename );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
