// =====================================================================
//  $Id: Sw01RunAction.hh,v 1.2 2004/03/04 15:11:55 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: Sw01RunAction.hh,v $
//  Revision 1.2  2004/03/04 15:11:55  goiwai
//  ۤȤɤؿ̾ѹˤȤʤǤ
//
//  Revision 1.1  2004/03/01 09:48:30  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
//  Revision 1.5  2004/01/19 21:10:27  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__SW01RUNACTION_HH
#define CLDAQ__SW01RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"
#include "Sw01RunSummary.hh"

class TRun;
class TOutputObjectFile;
class TDataRecord;

class Sw01RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    TOutputHtmlFileStream theOutputHtml;
    Sw01RunSummary theRunSummary;

  public:
    Sw01RunAction();
    ~Sw01RunAction();

  public:
    Tvoid Start( TRun& aRun );
    Tvoid Stop( TRun& aRun );
    Tvoid Suspend( TRun& aRun );
    Tvoid Resume( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    TOutputHtmlFileStream& GetOutputHtml();
    const Sw01RunSummary& GetRunSummary() const;

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid fillHtmlFile();

};

inline TOutputObjectFile* Sw01RunAction::GetOutputFile() const
{
  return theOutputFile;
}

inline TOutputHtmlFileStream& Sw01RunAction::GetOutputHtml()
{
  return theOutputHtml;
}

inline const Sw01RunSummary& Sw01RunAction::GetRunSummary() const
{
  return theRunSummary;
}

#endif
