// =====================================================================
//  $Id: Sw01RunSummary.cc,v 1.1 2004/03/01 09:48:30 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: Sw01RunSummary.cc,v $
//  Revision 1.1  2004/03/01 09:48:30  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
//  Revision 1.3  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "Sw01RunSummary.hh"

Sw01RunSummary::Sw01RunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfEvents( 0 ),
    theRunInformationTable(),
    theRunBeginTime(),
    theRunEndTime()
{;}

Sw01RunSummary::~Sw01RunSummary()
{;}

Tvoid Sw01RunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfEvents = 0;
  theRunInformationTable.Clear();
  theRunBeginTime.erase();
  theRunEndTime.erase();
  return;
}

TRunInformationTable Sw01RunSummary::GenerateRunSummaryTable() const
{
  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "Run ID", itostr( theRunID ) ) );
  infolist.push_back( TRunInformation( "Identification of object file", theRecordName ) );
  infolist.push_back( TRunInformation( "Size of object file", itostr( theRecordSize ) ) );
  infolist.push_back( TRunInformation( "Run Start", theRunBeginTime ) );
  infolist.push_back( TRunInformation( "Run Stop", theRunEndTime ) );
  infolist.push_back( TRunInformation( "Number of events", itostr( theNumberOfEvents ) ) );

  return theRunInformationTable + infolist;
}
