// =====================================================================
//  $Id: St01DarkDataSetInterface.cc,v 1.3 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: St01DarkDataSetInterface.cc,v $
//  Revision 1.3  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TInputObjectFile.hh"
#include "St01DarkDataSetInterface.hh"
#include "St01BadChannelMap.hh"
#include "St01OfflineDarkRmsMap.hh"
#include "St01OfflineDarkAverageMap.hh"
#include "St01DataRecordConversion.hh"
#include "St01DarkDataSet.hh"

static const Tstring _rcfile = "st01setup";

St01DarkDataSetInterface::St01DarkDataSetInterface( const Tstring& rcfile )
  : theDarkDataSetList(),
    theEnvironmentVariableTable( _rcfile ),
    theXrayPeakCount( theEnvironmentVariableTable.GetIntegerValue( "ST01_XRAY_PEAK_COUNT" ) ),
    theXrayPeakElectron( theEnvironmentVariableTable.GetIntegerValue( "ST01_XRAY_PEAK_ELECTRON" ) )
{
  // ADC1ȤŻҿ
  static const Tdouble factor = (Tdouble)theXrayPeakElectron / (Tdouble)theXrayPeakCount;
  TdoubleList temp;
  TdoubleList cycle;
  TdoubleList voltage;
  TstringList file;

  Tdouble t;
  Tdouble c;
  Tdouble v;
  Tstring f;

  Tifstream ifs;
  ifs.open( rcfile.c_str() );
  while ( ifs >> t >> c >> v >> f ) {
    temp.push_back( t );
    cycle.push_back( c );
    voltage.push_back( v );
    file.push_back( f );
  }
  ifs.close();


  for ( Tsize_t i = 0; i < file.size(); i ++ ) {
    St01BadChannelMap badmap( file[ i ] );

    Tdouble npixel = 0.0;
    Tdouble darksum = 0.0;

    const TDataMultiplicity& ave =
      badmap.GetOfflineDarkRmsMap().GetOfflineDarkAverageMap().GetMap();

    for ( Tint row = 0; row < ave.num_row(); row ++ ) {
      for ( Tint col = 0; col < ave.num_col(); col ++ ) {
	if ( badmap.IsGoodChannel( row, col ) ) {
	  darksum += ave[ row ][ col ];
	  npixel += 1.0;
	}
      }
    }

    Tdouble darkave = ( darksum / npixel ) * factor;


    St01DataRecordConversion conversion;
    TInputObjectFile ifile( file[ i ] );
    TDataRecord record;

    Tdouble rmssum = 0.0;
    Tdouble rmscount = 0.0;
    while ( ( ifile >> record ) != 0 ) {
      TDataElement element;
      Tstring recid = record.GetID();
      if ( recid == "EVENT" ) {
	const TDataMultiplicity& map = conversion.Convert( record );
	if ( conversion.IsSuccess() ) {
	  for ( Tint row = 0; row < map.num_row(); row ++ ) {
	    for ( Tint col = 0; col < map.num_col(); col ++ ) {
	      if ( badmap.IsGoodChannel( row, col ) ) {
		Tdouble s = map[ row ][ col ] - darksum/npixel;
		rmssum += pow( s, 2.0 );
		rmscount += 1.0;
	      }
	    }
	  }
	}
      } else if ( recid == "RUN END" ) {
	break;
      }
    }

    Tdouble rms = sqrt( rmssum / rmscount ) * factor;
    Tint nbad = badmap.GetNumberOfBadChannels();
    St01DarkDataSet dataset( temp[ i ], cycle[ i ], voltage[ i ], darkave, rms, rmscount, nbad, file[ i ] );

    theDarkDataSetList.push_back( dataset );
  }
}

St01DarkDataSetInterface::~St01DarkDataSetInterface()
{;}
