// =====================================================================
//  $Id: St02Map.cc,v 1.3 2003/10/06 16:28:19 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: St02Map.cc,v $
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St02Map.hh"

static const Tstring _rcfile = "st02setup";

St02Map::St02Map( const Tstring& filename )
  : theEnvironmentVariableTable( _rcfile ),
    theNumberOfHorizontalPixels( theEnvironmentVariableTable.GetIntegerValue( "ST02_HPIXEL" ) ),
    theNumberOfVerticalPixels( theEnvironmentVariableTable.GetIntegerValue( "ST02_VPIXEL" ) ),
    theHorizontalOffset( theEnvironmentVariableTable.GetIntegerValue( "ST02_HOFFSET" ) ),
    theVerticalOffset( theEnvironmentVariableTable.GetIntegerValue( "ST02_VOFFSET" ) ),
    theRateOfVerticalShift( theEnvironmentVariableTable.GetIntegerValue( "ST02_VSHIFT_CYCLE" ) ),
    theNumberOfHorizontalOverClockPixels( theEnvironmentVariableTable.GetIntegerValue( "ST02_HOC_PIXEL" ) ),
    theInputFileName( filename ),
    theHOCbuffer( 0.0 ),
    theMap( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 ),
    theHOCaverage( theNumberOfVerticalPixels, 0.0 )
{;}

St02Map::~St02Map()
{;}

Tpixel_t St02Map::IsThisPixel( Tint dataid ) const
{
  Tint colid = dataid % theRateOfVerticalShift;
  Tint rowid = dataid / theRateOfVerticalShift;
  Tint endofhoc = 276 + theNumberOfHorizontalOverClockPixels - 1;

  // ᤦǤϤʤե뤫褦
  // Ϥ4饤261饤ʹߤ̵
  if ( rowid >= 0 && rowid <= 3 ) {
    return tIgnore;
  } else if ( rowid >= 260 ) {
    return tIgnore;
  }

  if ( colid >= 0 && colid <= 3 ) {
    return tBlank;
  } else if ( colid >= 4 && colid <= 11 ) {
    return tOpticalBlack;
  } else if ( colid >= 12 && colid <= 267 ) {
    return tSignal;
  } else if ( colid >= 268 && colid <= 271 ) {
    return tOpticalBlack;
  } else if ( colid >= 272 && colid <= 275 ) {
    return tBlank;
  } else if ( colid >= 276 && colid < endofhoc ) {
    return tHoc;
  } else if ( colid == endofhoc ) {
    return tEndOfHoc;
  } else if ( colid == 307 ) {
    return tDummy;
  } else if ( colid >= 308 && colid <= 319 ) {
    return tVerticalShift;
  } else {
    return tIgnore;
  }
}

Tvoid St02Map::FillMap( Tshort* data, Tint ndata )
{
  theHOCaverage = TdoubleList( theNumberOfVerticalPixels, 0.0 );

  for ( Tint i = 0; i < ndata; i ++ ) {
    Tpixel_t pt = IsThisPixel( i );
    Tint colid = i % theRateOfVerticalShift - theHorizontalOffset;
    Tint rowid = i / theRateOfVerticalShift - theVerticalOffset;

    if ( pt == tSignal ) {
      theMap[ rowid ][ colid ] = (Tdouble)data[ i ];
    } else if ( pt == tHoc ) {
      theHOCbuffer += data[ i ];
    } else if ( pt == tEndOfHoc ) {
      theHOCbuffer += data[ i ];
      Tdouble ave = theHOCbuffer / (Tdouble)theNumberOfHorizontalOverClockPixels;
      theHOCaverage[ rowid ] = ave;
      for ( Tint col = 0; col < theNumberOfHorizontalPixels; col ++ ) {
	theMap[ rowid ][ col ] -= ave;
      }
      theHOCbuffer = 0.0;
    } else if ( rowid >= 256 ) {
      break;
    } else {
      continue;
    }
  }
  return;
}
