// =====================================================================
/*!
//
//  \file TAnalysisAction.hh
//  \brief This file contains the TAnalysisAction class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TAnalysisAction.hh,v 1.6 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: TAnalysisAction.hh,v $
//  Revision 1.6  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:38  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:10  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:36  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TANALYSISACTION_HH
#define CLDAQ__TANALYSISACTION_HH

#include "Tglobals.h"

class TMatrixElement;
class TAnalyser;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TAnalysisAction
// \brief This is the TAnalysisAction class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TAnalysisAction class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup AnalysisCategory
*/
class TAnalysisAction
{

  public:
    TAnalysisAction();
    virtual ~TAnalysisAction();

  public:
    virtual Tvoid BeginOfAnalysisAction( TAnalyser* analyser, const Tstring& id );
    virtual Tvoid UpdateOfAnalysisAction( TAnalyser* analyser, TMatrixElement& matrix );
    virtual Tvoid EndOfAnalysisAction( TAnalyser* analyser, const Tstring& id );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TAnalysisAction,0)
#endif

};

#endif
