// =====================================================================
//  $Id: TAnalysisStatus.cc,v 1.4 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: TAnalysisStatus.cc,v $
//  Revision 1.4  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:36  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TAnalysisStatus.hh"
#include "Tsuffix.h"

TAnalysisStatus::TAnalysisStatus( const Tstring& id, Tobject_t type, const Tstring& objectid, const Tstring& canvasid, Tstatus_t status )
  : theID( id ), theObjectType( type ), theDrawableObjectID( objectid ),
    theCanvasID( canvasid ), theStatus( status ), theThreadID( 0 )
{
  SetObjectType( theObjectType );
  theStatus = tStatusDead;
}

TAnalysisStatus::TAnalysisStatus( const TAnalysisStatus& right )
  : theID( right.theID ), theObjectType( right.theObjectType ),
    theDrawableObjectID( right.theDrawableObjectID ),
    theCanvasID( right.theCanvasID ), theStatus( right.theStatus ),
    theThreadID( right.theThreadID )
{;}

TAnalysisStatus::~TAnalysisStatus()
{;}

const TAnalysisStatus& TAnalysisStatus::operator=( const TAnalysisStatus& right )
{
  theID = right.theID;
  theObjectType = right.theObjectType;
  theDrawableObjectID = right.theDrawableObjectID;
  theCanvasID = right.theCanvasID;
  theStatus = right.theStatus;
  theThreadID = right.theThreadID;
  return *this;
}

Tbool TAnalysisStatus::operator==( const TAnalysisStatus& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( theID == right.theID );
  retval &= ( theObjectType == right.theObjectType );
  retval &= ( theDrawableObjectID == right.theDrawableObjectID );
  retval &= ( theCanvasID == right.theCanvasID );
  retval &= ( theStatus == right.theStatus );
  retval &= ( theThreadID == right.theThreadID );
  return retval;
}

Tbool TAnalysisStatus::operator!=( const TAnalysisStatus& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( theID != right.theID );
  retval |= ( theObjectType != right.theObjectType );
  retval |= ( theDrawableObjectID != right.theDrawableObjectID );
  retval |= ( theCanvasID != right.theCanvasID );
  retval |= ( theStatus != right.theStatus );
  retval |= ( theThreadID != right.theThreadID );
  return retval;
}

Tostream& operator<<( Tostream& tos, const TAnalysisStatus& right )
{
  tos << right.theID << ": ";
  Tstring msgbuf;
  switch ( right.theObjectType ) {
    case tObject1DHistogram:
      msgbuf = "Histogram(1D)";
      break;
    case tObject2DHistogram:
      msgbuf = "Histogram(2D)";
      break;
    case tObjectAppendGraph:
      msgbuf = "Graph(App)";
      break;
    case tObjectSubstituteGraph:
      msgbuf = "Graph(Sub)";
      break;
    case tObjectNtuple:
      msgbuf = "Ntuple";
      break;
    default:
      msgbuf = "Unknown";
      break;
  }
  tos << msgbuf << "(" << right.theObjectType << ")" << Twspace;
  tos << right.theCanvasID << Twspace;
  switch ( right.theStatus ) {
    case tStatusStandby:
      msgbuf = "Standby";
      break;
    case tStatusReady:
      msgbuf = "Ready";
      break;
    case tStatusBusy:
      msgbuf = "Busy";
      break;
    case tStatusIdle:
      msgbuf = "Idle";
      break;
    case tStatusWaitingReady:
      msgbuf = "WaitingReady";
      break;
    case tStatusDead:
      msgbuf = "Dead";
      break;
    case tStatusSleep:
      msgbuf = "Sleep";
      break;
    default:
      msgbuf = "Unknown";
      break;
  }
  tos << msgbuf << "(" << right.theStatus << ")" << Twspace;
  tos << "Thread(" << right.theThreadID << ")" << Tflush;
  return tos;
}

Tvoid TAnalysisStatus::SetObjectType( Tobject_t type )
{
  theObjectType = type;
  switch ( theObjectType ) {
    case tObject1DHistogram:
      theDrawableObjectID = theID + T1DHistogramSuffix;
      break;
    case tObject2DHistogram:
      theDrawableObjectID = theID + T2DHistogramSuffix;
      break;
    case tObjectAppendGraph:
      theDrawableObjectID = theID + TAppendGraphSuffix;
      break;
    case tObjectSubstituteGraph:
      theDrawableObjectID = theID + TSubstituteGraphSuffix;
      break;
    case tObjectNtuple:
    default:
      theDrawableObjectID = theID + TUnknownSuffix;
      break;
  }
  theCanvasID = theID + TCanvasSuffix;
  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TAnalysisStatus)
#endif
