#! /bin/sh

clean() {
    find . -maxdepth 1 -type l -exec rm -f {} \;
    rm -f IO.cxx IO.h
}

link() {
    if test -z "$CLDAQ_INSTALL"; then
	echo "INVALID: CLDAQ_INSTALL=$CLDAQ_INSTALL"
	exit 1
    fi
    sys="TSystemClock.hh TSystemClock.cc TSystemTimer.hh TSystemTimer.cc TDataDeflation.hh TDataDeflation.cc TDataInflation.hh TDataInflation.cc TSystemLogging.hh TSystemLogging.cc TFileProperty.hh TFileProperty.cc"
    for f in $sys; do
	ln -s $CLDAQ_INSTALL/source/system/$f .
    done

    ln -s $CLDAQ_INSTALL/source/datarecord/T*.hh .
    ln -s $CLDAQ_INSTALL/source/datarecord/T*.cc .

    ln -s $CLDAQ_INSTALL/source/persistency/T*.hh .
    ln -s $CLDAQ_INSTALL/source/persistency/T*.cc .
}

case "$1" in
    clean)
	clean
	;;
    link)
	link
	;;
    *)
	clean
	link
	;;
esac

exit 0
