// =====================================================================
/*!
//
//  \file TEvent.hh
//  \brief This file contains the TEvent class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TEvent.hh,v 1.6 2004/03/07 10:30:30 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: TEvent.hh,v $
//  Revision 1.6  2004/03/07 10:30:30  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:40  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:12  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:56:02  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:18:09  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TEVENT_HH
#define CLDAQ__TEVENT_HH

#include "Tglobals.h"
#include "TDataRecord.hh"

class TDataRecord;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TEvent
// \brief This is the TEvent class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TEvent class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup EventCategory
*/
class TEvent
{
    
  private:
    Tint theEventID;
    TDataRecord theDataRecord;

  public:
    TEvent( Tint eventID = 0 );
    TEvent( const TDataRecord& eventData );
    TEvent( Tint eventID, const TDataRecord& eventData );
    TEvent( const TEvent& right );
    ~TEvent();

  public:
    const TEvent& operator=( const TEvent& right );
    Tbool operator==( const TEvent& right ) const;
    Tbool operator!=( const TEvent& right ) const;

  public:
    Tint GetEventID() const;
    const TDataRecord& GetDataRecord() const;
    TDataRecord& GetDataRecord();
    Tvoid SetEventID( Tint eventID );
    Tvoid SetDataRecord( const TDataRecord& record );

  public:
    Tvoid Clear();
    Tstring GetStringEventID( Tint digits = 6 ) const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TEvent,0)
#endif

};

inline Tint TEvent::GetEventID() const
{
  return theEventID;
}

inline const TDataRecord& TEvent::GetDataRecord() const
{
  return theDataRecord;
}

inline TDataRecord& TEvent::GetDataRecord()
{
  return theDataRecord;
}

inline Tvoid TEvent::SetEventID( Tint eventID )
{
  theEventID = eventID;
  return;
}

inline Tvoid TEvent::SetDataRecord( const TDataRecord& record )
{
  theDataRecord = record;
  return;
}

#endif
