// =====================================================================
/*!
//
//  \file TCamacCrateController.hh
//  \brief This file contains the TCamacCrateController class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCamacCrateController.hh,v 1.7 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: TCamacCrateController.hh,v $
//  Revision 1.7  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/11/04 07:40:13  goiwai
//  CAMACɥ饤Фإ󥿡եʬǤ CamacDriverInterface ̾
//   TCamacDriverInterface ѹޤ.
//  ޤηTCamacModule饹Ĥޤ.
//  ¾,ʸˡỤ̵̄ʬޤ.긵˥ϡɤʤΤ,ư
//  ǧƤޤ,⤷ưʤʤ褦ʤ餳ʬǤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:09  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TCAMACCRATECONTROLLER_HH
#define CLDAQ__TCAMACCRATECONTROLLER_HH

#include "Tglobals.h"
#include "TModule.hh"

#define CC7x00_IOC_MAGIC 0xcc
#define IOC_TEST_ONLINE _IO( CC7x00_IOC_MAGIC, 0x02 )
#define IOC_RESET_CRATE _IO( CC7x00_IOC_MAGIC, 0x03 )
#define IOC_SET_Z _IO( CC7x00_IOC_MAGIC, 0x04 )
#define IOC_SET_C _IO( CC7x00_IOC_MAGIC, 0x05 )
#define IOC_SET_I _IO( CC7x00_IOC_MAGIC, 0x06 )
#define IOC_RESET_I _IO( CC7x00_IOC_MAGIC, 0x07 )
#define IOC_SET_EI _IO( CC7x00_IOC_MAGIC, 0x08 )
#define IOC_RESET_EI _IO( CC7x00_IOC_MAGIC, 0x09 )
#define IOC_SET_LI _IO( CC7x00_IOC_MAGIC, 0x0a )
#define IOC_RESET_LI _IO( CC7x00_IOC_MAGIC, 0x0b )
#define IOC_SET_CN _IOW( CC7x00_IOC_MAGIC, 0x0c, TUint )
#define IOC_WAIT_LAM _IOW( CC7x00_IOC_MAGIC, 0x0d, TUint** )
#define IOC_GET_LAM _IOR( CC7x00_IOC_MAGIC, 0x0e, TUint* )
#define IOC_CAM16 _IOR( CC7x00_IOC_MAGIC, 0x0f, struct TCamacDriverInterface )
#define IOC_CAM24 _IOR( CC7x00_IOC_MAGIC, 0x10, struct TCamacDriverInterface )


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCamacCrateController
// \brief This is the TCamacCrateController class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCamacCrateController class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TCamacCrateController
  : public TModule
{

  private:
    TcamacCrateController_t theCrateControllerType;
    Tint theCrateID;
    Tint theFileDescriptor;
    Tbool theISA7000;

  public:
    TCamacCrateController();
    TCamacCrateController( TcamacCrateController_t cctype );
    TCamacCrateController( const TCamacCrateController& right );
    ~TCamacCrateController();

  public:
    Tbool IsOnline();
    Tbool IsOpen();
    Tvoid Open();
    Tvoid Close();
    Tint Reset();
    Tint SetInhibition();
    Tint ReleaseInhibition();
    Tint EnableInterrupt();
    Tint DisableInterrupt();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    const TCamacCrateController& operator=( const TCamacCrateController& right );
    Tbool operator==( const TCamacCrateController& right ) const;
    Tbool operator!=( const TCamacCrateController& right ) const;

  public:
    TcamacCrateController_t GetCrateControllerType() const;
    Tint GetCrateID() const;
    Tint GetFileDescriptor() const;
    Tvoid SetCrateControllerType( TcamacCrateController_t type );
    Tvoid SetCrateID( Tint crateid );
    Tvoid SetFileDescriptor( Tint fd );
    Tbool IsISA7000() const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TCamacCrateController,0)
#endif

};

inline TcamacCrateController_t TCamacCrateController::GetCrateControllerType() const
{
  return theCrateControllerType;
}

inline Tint TCamacCrateController::GetCrateID() const
{
  return theCrateID;
}

inline Tint TCamacCrateController::GetFileDescriptor() const
{
  return theFileDescriptor;
}

inline Tvoid TCamacCrateController::SetFileDescriptor( Tint fd )
{
  theFileDescriptor = fd;
  return;
}

inline Tbool TCamacCrateController::IsISA7000() const
{
  return theISA7000;
}

#endif
