// =====================================================================
/*!
//
//  \file TModule.hh
//  \brief This file contains the TModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TModule.hh,v 1.6 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: TModule.hh,v $
//  Revision 1.6  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TMODULE_HH
#define CLDAQ__TMODULE_HH

#include "Tglobals.h"

class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TModule
// \brief This is the TModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TModule
{

  public:
    enum { tStatusSuccess = 0 };

  protected:
    Tint theNumberOfChannels;
    Tint theStatus;

  public:
    TModule( Tint nchannel = 0 );
    TModule( const TModule& right );
    virtual ~TModule();

  public:
    virtual Tint Clear() = 0;
    virtual Tint Update() = 0;
    virtual Tint Initialize() = 0;
    virtual Tvoid FillData( TDataElement& element, Tint channel ) = 0;

  public:
    virtual const TModule& operator=( const TModule& right );
    virtual Tbool operator==( const TModule& right ) const;
    virtual Tbool operator!=( const TModule& right ) const;

  public:
    Tint GetNumberOfChannels() const;
    Tint GetStatus() const;
    Tvoid SetNumberOfChannels( Tint nchannel );
    Tvoid SetStatus( Tint status );
    Tbool IsSuccess() const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TModule,0)
#endif

};

inline Tint TModule::GetNumberOfChannels() const
{
  return theNumberOfChannels;
}

inline Tvoid TModule::SetNumberOfChannels( Tint nchannel )
{
  theNumberOfChannels = nchannel;
  return;
}

inline Tint TModule::GetStatus() const
{
  return theStatus;
}

inline Tvoid TModule::SetStatus( Tint status )
{
  theStatus = status;
  return;
}

inline Tbool TModule::IsSuccess() const
{
  return ( theStatus >= 0 ) ? Ttrue : Tfalse;
}

#endif
