// =====================================================================
/*!
//
//  \file TOutputObjectFilter.hh
//  \brief This file contains the TOutputObjectFilter class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TOutputObjectFilter.hh,v 1.3 2004/03/07 10:30:32 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: TOutputObjectFilter.hh,v $
//  Revision 1.3  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.2  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.1  2003/12/06 10:18:15  goiwai
//  ϥե륿Ƚϥե륿̰ˤޤ.
//  Ͻ貾۴ؿFiltering()ޤߤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TOUTPUTOBJECTFILTER_HH
#define CLDAQ__TOUTPUTOBJECTFILTER_HH

#include "Tglobals.h"
#include "TObjectFilter.hh"

class TStreamableObject;
class TInputObjectStream;
class TOutputObjectStream;
class TObjectStream;

/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TOutputObjectFilter
// \brief This is the TOutputObjectFilter class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TOutputObjectFilter class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TOutputObjectFilter
  : public TObjectFilter
{

  public:
    TOutputObjectFilter();
    virtual ~TOutputObjectFilter();

  public:
    virtual Tint Filtering( TStreamableObject& object, TOutputObjectStream* stream ) = 0;
    virtual Tvoid Initialize( TOutputObjectStream* stream );
    virtual Tvoid Finalize( TOutputObjectStream* stream );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TOutputObjectFilter,0)
#endif

};

inline Tvoid TOutputObjectFilter::Initialize( TOutputObjectStream* stream )
{
  return;
}

inline Tvoid TOutputObjectFilter::Finalize( TOutputObjectStream* stream )
{
  return;
}

#endif
