// =====================================================================
/*!
//
//  \file TReadoutSegment.hh
//  \brief This file contains the TReadoutSegment class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TReadoutSegment.hh,v 1.7 2004/03/07 10:30:33 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: TReadoutSegment.hh,v $
//  Revision 1.7  2004/03/07 10:30:33  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:42  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TREADOUTSEGMENT_HH
#define CLDAQ__TREADOUTSEGMENT_HH

#include "Tglobals.h"
#include "TReadoutIdentification.hh"
#include "TReadoutElementList.hh"

class TModule;
class TDataSegment;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TReadoutSegment
// \brief This is the TReadoutSegment class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TReadoutSegment class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ReadoutCategory
*/
class TReadoutSegment
  : public TReadoutIdentification, public TReadoutElementList
{

  private:
    TModule* theModule;

  public:
    TReadoutSegment( const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, Tint ch, const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, const TstringList& elementid, const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, const Tstring elementid[], const Tstring& id = TunknownID );
    TReadoutSegment( const TReadoutSegment& right );
    ~TReadoutSegment();

  public:
    const TReadoutSegment& operator=( const TReadoutSegment& right );
    Tbool operator==( const TReadoutSegment& right ) const;
    Tbool operator!=( const TReadoutSegment& right ) const;

  public:
    TDataSegment Read();

  public:
    TModule* GetModule() const;
    Tvoid SetModule( TModule* module );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TReadoutSegment,0)
#endif

};

inline TModule* TReadoutSegment::GetModule() const
{
  return theModule;
}

inline Tvoid TReadoutSegment::SetModule( TModule* module )
{
  theModule = module;
  return;
}

#endif
