// =====================================================================
/*!
//
//  \file TSystemAction.hh
//  \brief This file contains the TSystemAction class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSystemAction.hh,v 1.9 2004/06/28 07:17:37 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: TSystemAction.hh,v $
//  Revision 1.9  2004/06/28 07:17:37  goiwai
//  TclogΥǥեȤΥ٥INFO٥ˤޤ
//
//  Revision 1.8  2004/06/24 15:15:26  goiwai
//  ѹ
//  Tcout,Tcerr,TlogХåեͳˤ
//  ĤexternTlog,Tcout,Tcerr,Tinfo...Tcritʤɽϴط
//
//  Revision 1.7  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/03/04 14:52:28  goiwai
//  BeginOfSystemAction -> Boot
//  EndOfSystemAction -> Shutdown
//
//  Revision 1.5  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TSYSTEMACTION_HH
#define CLDAQ__TSYSTEMACTION_HH

#include "Tglobals.h"

class TRunManager;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSystemAction
// \brief This is the TSystemAction class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSystemAction class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TSystemAction
{

  public:
    TSystemAction();
    virtual ~TSystemAction();

  public:
    //virtual Tvoid BeginOfSystemAction( TRunManager* manager );
    //virtual Tvoid EndOfSystemAction( TRunManager* manager );
    virtual Tvoid Boot( TRunManager* manager );
    virtual Tvoid Shutdown( TRunManager* manager );

  public:
    virtual Tvoid CatchStandardOut( Tstring message );
    virtual Tvoid CatchStandardError( Tstring message );
    virtual Tvoid CatchLog( Tstring message, Tint level );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TSystemAction,0)
#endif

};

#endif
