// =====================================================================
//  $Id: decompress.cc,v 1.4 2003/12/06 11:03:23 goiwai Exp $
//  $Name: CLDAQ-1-14-04 $
//  $Log: decompress.cc,v $
//  Revision 1.4  2003/12/06 11:03:23  goiwai
//  ХåեμؤƤäΤľޤ.
//
//  Revision 1.3  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.2  2003/07/30 16:21:38  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataInflation.hh"
#include "TArgument.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
#ifdef __CLDAQ_ZLIB_USE
  TArgument arg( argc, argv );
  if ( arg.GetNumberOfElements() != 2 ) {
    arg.ShowUsage();
  }
  const Tstring ifname = arg.GetElement( 0 );
  const Tstring ofname = arg.GetElement( 1 );

  TDataInflation inflation;

  const Tint bufsize = 256;
  Tbyte input[ bufsize ];

  Tifstream ifs;
  ifs.open( ifname.c_str() );

  Tofstream ofs;
  ofs.open( ofname.c_str() );

  TBenchmark bench;
  bench.Start();
  while ( ifs.good() && !ifs.eof() ) {
    ifs.read( (Tchar*)input, bufsize );
    inflation.Decompress( input, ifs.gcount() );
    ofs.write( (Tchar*)inflation.GetInflatedData(), inflation.GetSizeOfInflatedData() );
  }
  bench.Stop();
  Tcout << bench << Tendl;

  ifs.close();
  ofs.close();
#endif
  return 0;
}
