// =====================================================================
//  $Id: rs00view.cc,v 1.7 2003/10/12 18:13:11 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: rs00view.cc,v $
//  Revision 1.7  2003/10/12 18:13:11  goiwai
//  Ρ
//
//  Revision 1.6  2003/10/12 18:11:17  goiwai
//  TInputObjectFile -> TInputObjectFileOnline ѹޤ.
//
//  Revision 1.5  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.4  2003/07/30 16:14:23  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFileOnline.hh"
#include "TRandomFlat.hh"
#include "Trootinit.h"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <filename>" << Tendl;
    return -1;
  }
  TInputObjectFileOnline ifile( argv[ 1 ] );
  TDataRecord rec;

  TApplication* theApplication = rootinit();

  //ϻ֤ǡ쥳ɤȤäƤ(ÿ)
  //ºݤˤϥӥΥ쥳ɤ
  //ǤϤȤꤢˡ
  Ttime_t start = time( 0 );
  gStyle -> SetTimeOffset( start );
  gStyle -> SetPadBottomMargin( 0.16 );

  TCanvas CVrs232c( "CVrs232c", "RE232C Readout Viewer" );


  //one bin = 1 second. change it to set the time scale
  TH1D H1Dht( "H1Dht","KEITHLEY MODEL 2400", 10, 0.0, 10.0 );

  H1Dht.SetMaximum( 1200.0 );
  H1Dht.SetMinimum( 600.0 );
  H1Dht.SetStats( 0 );
  H1Dht.GetXaxis() -> SetTimeDisplay( 1 );
  H1Dht.SetMarkerStyle( 1 );
  H1Dht.Draw( "p" );
  //H1Dht.Draw( "lp" );
  //H1Dht.Draw( "c" );
  //H1Dht.Draw();
  //H1Dht.SetMarkerSize(0.5);

  while ( ifile.Read( rec ) ) {

    //get section 0, segment 0, element 0 with fast access method. res.
    TDataElement e0 = rec[ 0 ][ 0 ][ 0 ];
    //get section 0, segment 2, element 2 with fast access method. sec.
    TDataElement e1 = rec[ 0 ][ 2 ][ 2 ];

    Tdouble res;
    Tint sec;
    e0.StorePrimitives( &res );
    e1.StorePrimitives( &sec );

    H1Dht.SetBinContent( sec, res );

    H1Dht.GetXaxis() -> SetNdivisions( 504 );
    H1Dht.GetXaxis() -> SetLabelOffset( 0.02 );
    H1Dht.GetXaxis() -> SetTitleOffset( 1.4 );
    H1Dht.GetXaxis() -> SetTimeFormat( "%H:%M:%S" );
    H1Dht.GetXaxis() -> SetTitle( "Time (H:M:S)" );
    H1Dht.GetXaxis() -> CenterTitle();
    H1Dht.GetYaxis() -> SetTitleOffset( 1.2 );
    H1Dht.GetYaxis() -> SetTitle( "Resistance (#Omega)" );
    H1Dht.GetYaxis() -> CenterTitle();

    CVrs232c.Modified();
    CVrs232c.Update();
    gSystem -> ProcessEvents();
  }


  theApplication -> Run();
  return 0;
}
