// =====================================================================
//  $Id: Rs01ViewCommand.cc,v 1.7 2003/10/14 22:46:11 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: Rs01ViewCommand.cc,v $
//  Revision 1.7  2003/10/14 22:46:11  goiwai
//  GIFեǤ褦ˤåʤäΤ
//  % exec > /dev/null 2>&1 &
//  Ǽ¹Ԥ褦ˤޤ.
//
//  Revision 1.6  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.5  2003/07/30 16:14:41  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs01ViewCommand.hh"
#include "Rs01RunAction.hh"

static const Tstring _name = "/local/rs01view";
static const Tstring _desc = "KEITHLEY Multimeter Model 2700 with 7702";

Rs01ViewCommand::Rs01ViewCommand()
  : TCommand( _name, _desc )
{;}

Rs01ViewCommand::~Rs01ViewCommand()
{;}

Tvoid Rs01ViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable =
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "RS01_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "rs01view";
  Tint runid = theRunManager -> GetRun().GetRunID();

  args.push_back( comname );
  args.push_back( itostr( runid, 0 ) );
  args.push_back( " > /dev/null 2>&1 &" );

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
