// =====================================================================
//  $Id: St00CtiSolution.hh,v 1.4 2004/01/19 21:10:28 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: St00CtiSolution.hh,v $
//  Revision 1.4  2004/01/19 21:10:28  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.3  2003/10/06 16:28:17  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__ST0001CTISOLUTION_HH
#define CLDAQ__ST0001CTISOLUTION_HH

#include "Tglobals.h"
#include "St00SinglePixelList.hh"

class St00CtiSolution
{

  private:
    St00SinglePixelList theSinglePixelList;
    Tdouble theHorizontalCTI;
    Tdouble theVerticalCTI;
    Tdouble theInitialValue;
    Tdouble theErrorOfHorizontalCTI;
    Tdouble theErrorOfVerticalCTI;
    Tdouble theErrorOfInitialValue;

  public:
    St00CtiSolution( const St00SinglePixelList& list );
    ~St00CtiSolution();

  private:
    Tvoid resolve();
    Tvoid resolveError();

  public:
    const St00SinglePixelList& GetSinglePixelList() const;
    Tdouble GetHorizontalCTI() const;
    Tdouble GetVerticalCTI() const;
    Tdouble GetInitialValue() const;
    Tdouble GetErrorOfHorizontalCTI() const;
    Tdouble GetErrorOfVerticalCTI() const;
    Tdouble GetErrorOfInitialValue() const;

};

inline const St00SinglePixelList& St00CtiSolution::GetSinglePixelList() const
{
  return theSinglePixelList;
}

inline Tdouble St00CtiSolution::GetHorizontalCTI() const
{
  return theHorizontalCTI;
}

inline Tdouble St00CtiSolution::GetInitialValue() const
{
  return theInitialValue;
}

inline Tdouble St00CtiSolution::GetVerticalCTI() const
{
  return theVerticalCTI;
}

inline Tdouble St00CtiSolution::GetErrorOfHorizontalCTI() const
{
  return theErrorOfHorizontalCTI;
}

inline Tdouble St00CtiSolution::GetErrorOfInitialValue() const
{
  return theErrorOfInitialValue;
}

inline Tdouble St00CtiSolution::GetErrorOfVerticalCTI() const
{
  return theErrorOfVerticalCTI;
}

#endif
