// =====================================================================
//  $Id: St00MinusHocEventViewCommand.cc,v 1.3 2003/10/06 16:28:17 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: St00MinusHocEventViewCommand.cc,v $
//  Revision 1.3  2003/10/06 16:28:17  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

#include "St00MinusHocEventViewCommand.hh"
#include "St00RunAction.hh"

static const Tstring _name = "/local/minushocview";
static const Tstring _desc = "draw histogram subtracted H.O.C.\n1st: Nbin, 2nd, Xmin, 3rd: Xmax\nexample /local/minushocview 400 0.0 4096.0";

St00MinusHocEventViewCommand::St00MinusHocEventViewCommand()
  : TCommand( _name, _desc )
{;}

St00MinusHocEventViewCommand::~St00MinusHocEventViewCommand()
{;}

Tvoid St00MinusHocEventViewCommand::Execute( const TstringList& arguments )
{
  Tstring nbin;
  Tstring xmin;
  Tstring xmax;

  if ( arguments.size() != 3 ) {
    ShowCommandDetail();
    Tcout << "set parameters to default value." << Tendl;
    nbin = "400";
    xmin = "0.0";
    xmax = "4096.0";
  } else {
    nbin = arguments[ 0 ];
    xmin = arguments[ 1 ];
    xmax = arguments[ 2 ];
  }

  TUserInterface* ui = theRunManager -> GetUserInterface();
  St00RunAction* action = (St00RunAction*)( theRunManager -> GetRunAction() );
  Tstring runid = theRunManager -> GetRun().GetStringRunID();
  Tstring title = Twquote + "H.O.C. subtracted data, run " + runid + Twquote;

  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( "./../../bin/st00minushocview" );
  args.push_back( filename );
  args.push_back( title );
  args.push_back( nbin );
  args.push_back( xmin );
  args.push_back( xmax );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
