// =====================================================================
//  $Id: St02DarkDataSet.cc,v 1.4 2003/10/06 16:28:19 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: St02DarkDataSet.cc,v $
//  Revision 1.4  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/09/07 02:36:07  goiwai
//  󥹥ȥ饯ѹޤ.
//  ˥ե̾Ȥä,Υե뤫鲹پʤɤäƤƤ
//  ΤǤ,ǡ쥳ɤ˽񤭹ޤ줿ͤ򿮤褦ˤޤ.
//
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St02DarkDataSet.hh"

St02DarkDataSet::St02DarkDataSet( Tdouble temp, Tdouble atime, Tdouble vshift, Tdouble constant, Tdouble mean, Tdouble sigma, Tdouble constant_e, Tdouble mean_e, Tdouble sigma_e )
  : theTemperature(temp),
    theAccumulationTime(atime),
    theVerticalShiftVoltage(vshift),
    theConstant(constant),
    theMean(mean),
    theSigma(sigma),
    theErrorOfConstant(constant_e),
    theErrorOfMean(mean_e),
    theErrorOfSigma(sigma_e)
{;}

// ݤåʤ󤫤ʤ
St02DarkDataSet::St02DarkDataSet( Tdouble* pars )
  : theTemperature(pars[0]),
    theAccumulationTime(pars[1]),
    theVerticalShiftVoltage(pars[2]),
    theConstant(pars[3]),
    theMean(pars[4]),
    theSigma(pars[5]),
    theErrorOfConstant(pars[6]),
    theErrorOfMean(pars[7]),
    theErrorOfSigma(pars[8])
{;}

St02DarkDataSet::St02DarkDataSet( const St02DarkDataSet& right )
  : theTemperature(right.theTemperature),
    theAccumulationTime(right.theAccumulationTime),
    theVerticalShiftVoltage(right.theVerticalShiftVoltage),
    theConstant(right.theConstant),
    theMean(right.theMean),
    theSigma(right.theSigma),
    theErrorOfConstant(right.theErrorOfConstant),
    theErrorOfMean(right.theErrorOfMean),
    theErrorOfSigma(right.theErrorOfSigma)
{;}

St02DarkDataSet::~St02DarkDataSet()
{;}

const St02DarkDataSet& St02DarkDataSet::operator=( const St02DarkDataSet& right )
{
  theTemperature = right.theTemperature;
  theAccumulationTime = right.theAccumulationTime;
  theVerticalShiftVoltage = right.theVerticalShiftVoltage;
  theConstant = right.theConstant;
  theMean = right.theMean;
  theSigma = right.theSigma;
  theErrorOfConstant = right.theErrorOfConstant;
  theErrorOfMean = right.theErrorOfMean;
  theErrorOfSigma = right.theErrorOfSigma;
  return *this;
}

Tostream& operator<<( Tostream& tos, const St02DarkDataSet& right )
{
  tos << right.theTemperature << Tspace;
  tos << right.theAccumulationTime << Tspace;
  tos << right.theVerticalShiftVoltage << Tspace;
  tos << right.theConstant << Tspace;
  tos << right.theMean << Tspace;
  tos << right.theSigma << Tspace;
  tos << right.theErrorOfConstant << Tspace;
  tos << right.theErrorOfMean << Tspace;
  tos << right.theErrorOfSigma << Tspace;
  return tos;
}

Tistream& operator>>( Tistream& tis, St02DarkDataSet& right )
{
  tis >> right.theTemperature
      >> right.theAccumulationTime
      >> right.theVerticalShiftVoltage
      >> right.theConstant
      >> right.theMean
      >> right.theSigma
      >> right.theErrorOfConstant
      >> right.theErrorOfMean
      >> right.theErrorOfSigma;
  return tis;
}
