// =====================================================================
//  $Id: St02DarkViewCommand.cc,v 1.3 2003/10/06 16:28:19 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: St02DarkViewCommand.cc,v $
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "St02DarkViewCommand.hh"
#include "St02RunAction.hh"

static const Tstring _name = "/local/st02darkview";
static const Tstring _desc = "view histograms in DARK run.";

St02DarkViewCommand::St02DarkViewCommand()
  : TCommand( _name, _desc )
{;}

St02DarkViewCommand::~St02DarkViewCommand()
{;}

Tvoid St02DarkViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "ST02_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "st02darkview";
  Tstring runid = theRunManager -> GetRun().GetStringRunID();

  args.push_back( comname );
  args.push_back( runid );
  args.push_back( "&" );

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
