// =====================================================================
//  $Id: St02OfflineDarkRmsMap.cc,v 1.3 2003/10/06 16:28:19 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: St02OfflineDarkRmsMap.cc,v $
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St02OfflineDarkRmsMap.hh"
#include "St02OfflineDarkAverageMap.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TDataMultiplicity.hh"
#include "TInputObjectFile.hh"

St02OfflineDarkRmsMap::St02OfflineDarkRmsMap( const Tstring& filename )
  : St02Map( filename ), theOfflineDarkAverageMap( theInputFileName )
{
  const TDataMultiplicity& avemap = theOfflineDarkAverageMap.GetMap();

  Tstring fadcidset[ 3 ] = { "EVENT", "ADC", "0" };
  TInputObjectFile ifile( theInputFileName );
  TDataRecord r;
  Tint nframe = 0;

  TDataMultiplicity mapbuf( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 );
  TDataMultiplicity diff( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 );


  //Xn=(x1+x2+x3+ ... + xn)/n
  //1=x1-Xn, 2=x2-Xn, 3=x3-Xn, ..., n=xn-Xn
  //ʬ
  //(n)^2=(1)^2 + (2)^2 + (3)^2 + ... + (n)^2 / n
  //RMSȤ n(nĤ¬ͤФ) 褦ȤƤޤ

  while ( ( ifile >> r ) != 0 ) {
    TDataElement e;
    if ( r.FindDataElement( fadcidset, e ) ) {
      Tshort* data = e.GetShortData();
      Tint ndata = e.GetNumberOfPrimitives();
      FillMap( data, ndata );
      diff = theMap - avemap;
      for ( Tint row = 0; row < diff.num_row(); row ++ ) {
	for ( Tint col = 0; col < diff.num_col(); col ++ ) {
	  diff[ row ][ col ] *= diff[ row ][ col ];
	}
      }
      mapbuf += diff;
      nframe ++;
    } else {
      continue;
    }
  }

  theMap = mapbuf / nframe;

  for ( Tint row = 0; row < theMap.num_row(); row ++ ) {
    for ( Tint col = 0; col < theMap.num_col(); col ++ ) {
      theMap[ row ][ col ] = sqrt( theMap[ row ][ col ] );
    }
  }

}

St02OfflineDarkRmsMap::~St02OfflineDarkRmsMap()
{;}
