// ============================================================================
//  $Id: TRecordDisplayMenuBar.cc,v 1.2 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TRecordDisplayMenuBar.cc,v $
//  Revision 1.2  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2004/03/01 02:36:25  goiwai
//  RecordDisplayѤΥ饹֤ޤ.
//  ¢ˤʤäƤΤ˼ľäΤǤ,
//  ޤԽʬߤޤ.˽ƤȻפޤ.
//  DataRecord֥Ȥɽ뤿Υġ뷲ʤΤRecordDisplayȸ
//  Ǥޤ,¿ʬ˥ե饤ǤǤ.
//  饤ˤΤEventDisplay(Eventɽ)Ȥƥߥå
//  ޤ.
//
// ============================================================================
#ifdef __CLDAQ_ROOT_USE
#include <TGWindow.h>
#include "TRecordDisplayMenuBar.hh"
#include "TRecordDisplay.hh"
#include "TRecordDisplayPreference.hh"

TRecordDisplayMenuBar::TRecordDisplayMenuBar( TRecordDisplay* d )
  : TRecordDisplayComponent( d ), 
    TGMenuBar( theRecordDisplay, 0, 0 ),
    theMenuFile( 0 ),
    theMenuCtrl( 0 ),
    theMenuEdit( 0 ),
    theMenuView( 0 )
{
  Build();
}

TRecordDisplayMenuBar::~TRecordDisplayMenuBar()
{
  delete theMenuFile;
  delete theMenuCtrl;
  delete theMenuEdit;
  delete theMenuView;
}

Tvoid TRecordDisplayMenuBar::Build()
{
  TRecordDisplay* p = theRecordDisplay;
  TGLayoutHints* pL = p -> GetPreference() -> GetPopupMenuLayoutHint();
  TGLayoutHints* mL = p -> GetPreference() -> GetMenuBarLayoutHint();
  const TGWindow* w = gClient -> GetRoot();

  theMenuFile = new TGPopupMenu( w );
  theMenuCtrl = new TGPopupMenu( w );
  theMenuEdit = new TGPopupMenu( w );
  theMenuView = new TGPopupMenu( w );

  theMenuFile -> AddLabel("Under Construction...");
  theMenuFile -> AddSeparator();
  theMenuFile -> AddEntry("&Open...", p->MENU_FILE_OPEN);
  theMenuFile -> AddEntry("&Browse...", p->MENU_FILE_BROWSE);
  theMenuFile -> AddSeparator();
  theMenuFile -> AddEntry("&Save", p->MENU_FILE_SAVE);
  theMenuFile -> AddEntry("Save As...", p->MENU_FILE_SAVEAS);
  theMenuFile -> AddSeparator();
  theMenuFile -> AddEntry("&Print", p->MENU_FILE_PRINT);
  theMenuFile -> AddEntry("Print As...", p->MENU_FILE_PRINTAS);
  theMenuFile -> AddSeparator();
  theMenuFile -> AddEntry("&Quit", p->MENU_FILE_QUIT);
  theMenuFile -> Associate( theRecordDisplay );

  theMenuCtrl -> AddLabel("Under Construction...");
  theMenuCtrl -> AddSeparator();
  theMenuCtrl -> AddEntry("&Start", p->MENU_CTRL_START);
  theMenuCtrl -> AddEntry("&Pause", p->MENU_CTRL_PAUSE);
  theMenuCtrl -> AddEntry("&Update", p->MENU_CTRL_UPDATE);
  theMenuCtrl -> AddEntry("&Stop", p->MENU_CTRL_STOP);
  theMenuCtrl -> Associate( theRecordDisplay );

  theMenuEdit -> AddLabel("Under Construction...");
  theMenuEdit -> AddSeparator();
  theMenuEdit -> AddEntry("&Edit", p->MENU_EDIT_EDIT);
  theMenuEdit -> AddEntry("&Undo", p->MENU_EDIT_UNDO);
  theMenuEdit -> AddEntry("&Clear", p->MENU_EDIT_CLEAR);
  theMenuEdit -> AddEntry("&Initialize", p->MENU_EDIT_INITIALIZE);
  theMenuEdit -> AddEntry("&Prefereces...", p->MENU_EDIT_PREFERENCES);
  theMenuEdit -> Associate( theRecordDisplay );

  theMenuView->AddLabel("Under Construction...");
  theMenuView->AddSeparator();
  theMenuView->AddEntry("Full &Screen", p->MENU_VIEW_FULL_SCREEN);
  theMenuView->AddEntry("&Iconify", p->MENU_VIEW_ICONIFY);
  theMenuView->AddEntry("&Color List", p->MENU_VIEW_COLOR_LIST);
  theMenuView->AddEntry("&Font List", p->MENU_VIEW_FONT_LIST);
  theMenuView->AddEntry("&Marker List", p->MENU_VIEW_MARKER_LIST);
  theMenuView->AddEntry("&X3D", p->MENU_VIEW_X3D);
  theMenuView->AddEntry("&Open GL", p->MENU_VIEW_OPEN_GL);
  theMenuView->Associate(theRecordDisplay);

  AddPopup("&File", theMenuFile, pL);
  AddPopup("&Ctrl", theMenuCtrl, pL);
  AddPopup("&Edit", theMenuEdit, pL);
  AddPopup("&View", theMenuView, pL);


  theRecordDisplay->AddFrame(this,mL);

  //theParentFrame -> MapSubwindows();
  //theParentFrame -> Layout();
  //theParentFrame -> MapWindow();

  theFinishBuild = Ttrue;

  return;
}
#endif

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TRecordDisplayMenuBar)
#endif
