// ============================================================================
//  $Id: TRecordDisplayPreference.cc,v 1.3 2004/06/24 15:15:24 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TRecordDisplayPreference.cc,v $
//  Revision 1.3  2004/06/24 15:15:24  goiwai
//  ѹ
//  Tcout,Tcerr,TlogХåեͳˤ
//  ĤexternTlog,Tcout,Tcerr,Tinfo...Tcritʤɽϴط
//
//  Revision 1.2  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2004/03/01 02:36:25  goiwai
//  RecordDisplayѤΥ饹֤ޤ.
//  ¢ˤʤäƤΤ˼ľäΤǤ,
//  ޤԽʬߤޤ.˽ƤȻפޤ.
//  DataRecord֥Ȥɽ뤿Υġ뷲ʤΤRecordDisplayȸ
//  Ǥޤ,¿ʬ˥ե饤ǤǤ.
//  饤ˤΤEventDisplay(Eventɽ)Ȥƥߥå
//  ޤ.
//
// ============================================================================
#ifdef __CLDAQ_ROOT_USE
#include "TRecordDisplayPreference.hh"
#include "TInputObjectFile.hh"
#include "TFileProperty.hh"

TRecordDisplayPreference* TRecordDisplayPreference::thePreference = 0;
TInputObjectStream* TRecordDisplayPreference::theStream = 0;

static const Tint _nbin = 512;
static const Tdouble _xmin = 0.0;
static const Tdouble _xmax = 4096.0;

TRecordDisplayPreference::TRecordDisplayPreference( TInputObjectStream* stream, const Tstring& style )
  : theUpdateCycle( 1 ),
    theSleepTime( -1 ),
    theTerminateAtLast( Tfalse ),
    theSaveRootAtLast( Ttrue ),
    theSavePsAtLast( Tfalse ),
    theSaveGifAtLast( Tfalse ),
    theEndOfRecordID(),
    theRootOfFileName(),
    theDefaultNumberOfBins( _nbin ),
    theDefaultMinimumX( _xmin ),
    theDefaultMaximumX( _xmax ),
    theStyleName( style ),
    theCanvasLayoutHint( 0 ),
    theTabLayoutHint( 0 ),
    thePopupMenuLayoutHint( 0 ),
    theMenuBarLayoutHint( 0 )
{
  if ( thePreference ) {
    Tcout << "Preference constructed twice." << Tendl;
    exit( EXIT_SUCCESS );
  }
  thePreference = this;
  theStream = stream;

  TStyle* st = gROOT -> GetStyle( theStyleName.c_str() );
  if ( st ) {
    st -> cd();
  } else {
    theStyleName = Tproject;
  }

  theCanvasLayoutHint =
    new TGLayoutHints( kLHintsCenterX|kLHintsCenterY|kLHintsExpandX|kLHintsExpandY, 0, 0, 0, 0 );
  theTabLayoutHint = 
    new TGLayoutHints( kLHintsCenterX|kLHintsCenterY|kLHintsExpandX|kLHintsExpandY,  10, 10, 10, 10 );
  thePopupMenuLayoutHint = new TGLayoutHints(kLHintsTop|kLHintsLeft,0,4);
  theMenuBarLayoutHint = new TGLayoutHints( kLHintsTop|kLHintsLeft|kLHintsExpandX );

}

TRecordDisplayPreference::~TRecordDisplayPreference()
{
  delete theCanvasLayoutHint;
  delete theTabLayoutHint;
  delete thePopupMenuLayoutHint;
  delete theMenuBarLayoutHint;

  if ( theStream ) {
    delete theStream;
    theStream = 0;
  }

  if ( thePreference ) {
    thePreference = 0;
  }
}

Tvoid TRecordDisplayPreference::GuessRootOfFileName()
{
  if ( theStream && theStream -> GetStreamType() == tFileStream ) {
    Tstring drec = ( (TInputObjectFile*)theStream ) -> GetFileName();
    TFileProperty pty( drec );
    theRootOfFileName = pty.GetFileRootName();
  } else {
    theRootOfFileName = Tproject;
  }
  return;
}

Tstring TRecordDisplayPreference::RootFile()
{
  GuessRootOfFileName();
  Tstring filename = theRootOfFileName + ".root";
  return filename;
}

#endif

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TRecordDisplayPreference)
#endif
