// ============================================================================
//  $Id: TRecordDisplayPreference.hh,v 1.2 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TRecordDisplayPreference.hh,v $
//  Revision 1.2  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2004/03/01 02:36:25  goiwai
//  RecordDisplayѤΥ饹֤ޤ.
//  ¢ˤʤäƤΤ˼ľäΤǤ,
//  ޤԽʬߤޤ.˽ƤȻפޤ.
//  DataRecord֥Ȥɽ뤿Υġ뷲ʤΤRecordDisplayȸ
//  Ǥޤ,¿ʬ˥ե饤ǤǤ.
//  饤ˤΤEventDisplay(Eventɽ)Ȥƥߥå
//  ޤ.
//
// ============================================================================
#ifdef __CLDAQ_ROOT_USE
#ifndef CLDAQ__TRECORDDISPLAYPREFERENCE_HH
#define CLDAQ__TRECORDDISPLAYPREFERENCE_HH

#include <TROOT.h>
#include <TStyle.h>
#include <TGLayout.h>
#include "Tglobals.h"
#include "TInputObjectStream.hh"

class TApplication;
class TInputObjectStream;
class TGLayoutHints;
class TStyle;

// Setȥ󥹥ȥ饯˥ݥ󥿤ϤȤϾ new Ƥ錄

class TRecordDisplayPreference
{

  private:
    static TRecordDisplayPreference* thePreference;
    static TInputObjectStream* theStream;

    Tint theUpdateCycle;
    Tint theSleepTime;
    Tbool theTerminateAtLast;
    Tbool theSaveRootAtLast;
    Tbool theSavePsAtLast;
    Tbool theSaveGifAtLast;
    Tstring theEndOfRecordID;
    Tstring theRootOfFileName;
    Tint theDefaultNumberOfBins;
    Tdouble theDefaultMinimumX;
    Tdouble theDefaultMaximumX;
    Tstring theStyleName;
    TGLayoutHints* theCanvasLayoutHint;
    TGLayoutHints* theTabLayoutHint;
    TGLayoutHints* thePopupMenuLayoutHint;
    TGLayoutHints* theMenuBarLayoutHint;

    //! å٥
    //! ǥեȤΥҥȥåȥӥ塼⤦äȤäۤ

  public:
    TRecordDisplayPreference( TInputObjectStream* stream = 0, const Tstring& style = "" );
    ~TRecordDisplayPreference();

  public:
    Tvoid GuessRootOfFileName();
    Tstring RootFile();

  public:
    static TRecordDisplayPreference* GetPreference();
    static TInputObjectStream* GetStream();
    static Tvoid SetStream( TInputObjectStream* stream );

  public:
    TApplication* GetApplication() const;
    Tint GetUpdateCycle() const;
    Tint GetSleepTime() const;
    Tbool TerminateAtLast() const;
    Tbool SaveRootAtLast() const;
    Tbool SavePsAtLast() const;
    Tbool SaveGifAtLast() const;
    const Tstring& GetRootOfFileName() const;
    Tint GetDefaultNumberOfBins() const;
    Tdouble GetDefaultMinimumX() const;
    Tdouble GetDefaultMaximumX() const;
    Tstring GetStyleName() const;
    TGLayoutHints* GetCanvasLayoutHint() const;
    TGLayoutHints* GetTabLayoutHint() const;
    TGLayoutHints* GetPopupMenuLayoutHint() const;
    TGLayoutHints* GetMenuBarLayoutHint() const;
    Tvoid SetUpdateCycle( Tint cycle );
    Tvoid SetSleepTime( Tint time );
    Tvoid SetTerminateAtLast( Tbool val );
    Tvoid SetSaveRootAtLast( Tbool val );
    Tvoid SetSavePsAtLast( Tbool val );
    Tvoid SetSaveGifAtLast( Tbool val );
    Tvoid SetRootOfFileName( const Tstring& filebody );
    Tvoid SetDefaultNumberOfBins( Tint nbin );
    Tvoid SetDefaultMinimumX( Tdouble xmin );
    Tvoid SetDefaultMaximumX( Tdouble xmax );
    Tvoid SetStyleName( const Tstring& style );
    Tvoid SetCanvasLayoutHint( TGLayoutHints* layout );
    Tvoid SetTabLayoutHint( TGLayoutHints* layout );
    Tvoid SetPopupMenuLayoutHint( TGLayoutHints* layout );
    Tvoid SetMenuBarLayoutHint( TGLayoutHints* layout );
    const Tstring& GetEndOfRecordID() const;
    Tvoid SetEndOfRecordID( const Tstring& id );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TRecordDisplayPreference,0)
#endif

};

inline TRecordDisplayPreference* TRecordDisplayPreference::GetPreference()
{
  if ( !thePreference ) {
    thePreference = new TRecordDisplayPreference();
  }
  return thePreference;
}

inline TInputObjectStream* TRecordDisplayPreference::GetStream()
{
  return theStream;
}

inline Tvoid TRecordDisplayPreference::SetStream( TInputObjectStream* stream )
{
  if ( thePreference->theStream ) {
    delete thePreference->theStream;
    thePreference->theStream = 0;
  }
  thePreference->theStream = stream;
  thePreference->GuessRootOfFileName();
  return;
}

inline Tint TRecordDisplayPreference::GetUpdateCycle() const
{
  return theUpdateCycle;
}

inline Tint TRecordDisplayPreference::GetSleepTime() const
{
  return theSleepTime;
}

inline Tbool TRecordDisplayPreference::TerminateAtLast() const
{
  return theTerminateAtLast;
}

inline Tbool TRecordDisplayPreference::SaveRootAtLast() const
{
  return theSaveRootAtLast;
}

inline Tbool TRecordDisplayPreference::SavePsAtLast() const
{
  return theSavePsAtLast;
}

inline Tbool TRecordDisplayPreference::SaveGifAtLast() const
{
  return theSaveGifAtLast;
}

inline const Tstring& TRecordDisplayPreference::GetRootOfFileName() const
{
  return theRootOfFileName;
}

inline Tint TRecordDisplayPreference::GetDefaultNumberOfBins() const
{
  return theDefaultNumberOfBins;
}

inline Tdouble TRecordDisplayPreference::GetDefaultMinimumX() const
{
  return theDefaultMinimumX;
}

inline Tdouble TRecordDisplayPreference::GetDefaultMaximumX() const
{
  return theDefaultMaximumX;
}

inline Tstring TRecordDisplayPreference::GetStyleName() const
{
  return theStyleName;
}

inline TGLayoutHints* TRecordDisplayPreference::GetCanvasLayoutHint() const
{
  return theCanvasLayoutHint;
}

inline TGLayoutHints* TRecordDisplayPreference::GetTabLayoutHint() const
{
  return theTabLayoutHint;
}

inline TGLayoutHints* TRecordDisplayPreference::GetPopupMenuLayoutHint() const
{
  return thePopupMenuLayoutHint;
}

inline TGLayoutHints* TRecordDisplayPreference::GetMenuBarLayoutHint() const
{
  return theMenuBarLayoutHint;
}

inline Tvoid TRecordDisplayPreference::SetUpdateCycle( Tint cycle )
{
  theUpdateCycle = cycle;
  return;
}

inline Tvoid TRecordDisplayPreference::SetSleepTime( Tint time )
{
  theSleepTime = time;
  return;
}

inline Tvoid TRecordDisplayPreference::SetTerminateAtLast( Tbool val )
{
  theTerminateAtLast = val;
  return;
}

inline Tvoid TRecordDisplayPreference::SetSaveRootAtLast( Tbool val )
{
  theSaveRootAtLast = val;
  return;
}

inline Tvoid TRecordDisplayPreference::SetSavePsAtLast( Tbool val )
{
  theSavePsAtLast = val;
  return;
}

inline Tvoid TRecordDisplayPreference::SetSaveGifAtLast( Tbool val )
{
  theSaveGifAtLast = val;
  return;
}

inline Tvoid TRecordDisplayPreference::SetRootOfFileName( const Tstring& filebody )
{
  theRootOfFileName = filebody;
  return;
}

inline Tvoid TRecordDisplayPreference::SetDefaultNumberOfBins( Tint nbin )
{
  theDefaultNumberOfBins = nbin;
  return;
}

inline Tvoid TRecordDisplayPreference::SetDefaultMinimumX( Tdouble xmin )
{
  theDefaultMinimumX = xmin;
  return;
}

inline Tvoid TRecordDisplayPreference::SetDefaultMaximumX( Tdouble xmax )
{
  theDefaultMaximumX = xmax;
  return;
}

inline Tvoid TRecordDisplayPreference::SetStyleName( const Tstring& style )
{
  TStyle* st = gROOT -> GetStyle( theStyleName.c_str() );
  if ( st ) {
    st -> cd();
  } else {
    theStyleName = Tproject;
  }
  return;
}

inline Tvoid TRecordDisplayPreference::SetCanvasLayoutHint( TGLayoutHints* layout )
{
  if ( theCanvasLayoutHint ) {
    delete theCanvasLayoutHint;
    theCanvasLayoutHint = 0;
  }
  theCanvasLayoutHint = layout;
  return;
}

inline Tvoid TRecordDisplayPreference::SetTabLayoutHint( TGLayoutHints* layout )
{
  if ( theTabLayoutHint ) {
    delete theTabLayoutHint;
    theTabLayoutHint = 0;
  }
  theTabLayoutHint = layout;
  return;
}

inline Tvoid TRecordDisplayPreference::SetPopupMenuLayoutHint( TGLayoutHints* layout )
{
  if ( thePopupMenuLayoutHint ) {
    delete thePopupMenuLayoutHint;
    thePopupMenuLayoutHint = 0;
  }
  thePopupMenuLayoutHint = layout;
  return;
}

inline Tvoid TRecordDisplayPreference::SetMenuBarLayoutHint( TGLayoutHints* layout )
{
  if ( theMenuBarLayoutHint ) {
    delete theMenuBarLayoutHint;
    theMenuBarLayoutHint = 0;
  }
  theMenuBarLayoutHint = layout;
  return;
}

inline const Tstring& TRecordDisplayPreference::GetEndOfRecordID() const
{
  return theEndOfRecordID;
}

inline Tvoid TRecordDisplayPreference::SetEndOfRecordID( const Tstring& id )
{
  theEndOfRecordID = id;
  return;
}

#endif
#endif
