// =====================================================================
/*!
//
//  \file TExecuteCommand.hh
//  \brief This file contains the TExecuteCommand class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TExecuteCommand.hh,v 1.6 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TExecuteCommand.hh,v $
//  Revision 1.6  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:38  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:11  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TEXECUTECOMMAND_HH
#define CLDAQ__TEXECUTECOMMAND_HH

#include "Tglobals.h"
#include "TCommand.hh"
#include "TMacroFileParser.hh"

class TMacroFileParser;
class TUserInterface;
class TRunManager;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TExecuteCommand
// \brief This is the TExecuteCommand class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TExecuteCommand class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup CommandsCategory
*/
class TExecuteCommand
  : public TCommand
{

  protected:
    TMacroFileParser theMacroFileParser;

  public:
    TExecuteCommand( TRunManager* manager );
    virtual ~TExecuteCommand();

  public:
    virtual Tvoid Execute( const TstringList& arguments );

  protected:
    virtual Tvoid doExecute( TUserInterface* ui, const Tstring& filename, Tint nloop = 1 );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TExecuteCommand,0)
#endif

};

#endif
