// =====================================================================
//  $Id: TRunStartCommand.cc,v 1.6 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TRunStartCommand.cc,v $
//  Revision 1.6  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.4  2003/07/30 18:17:56  goiwai
//  /run/startޥɤѤʰͿȤ˵Զޤ.
//
//  Revision 1.3  2003/07/30 16:17:32  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunStartCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/run/start";
static const Tstring _desc = "start a run.\nif you give a argument, set to run identification.\nhowever, it is omittable.\nexample> /run/start\nexample> /run/start 12345";

TRunStartCommand::TRunStartCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TRunStartCommand::~TRunStartCommand()
{;}

Tvoid TRunStartCommand::Execute( const TstringList& arguments )
{
  if ( !( arguments.empty() ) ) {
    if ( arguments.size() == 1 ) {
      Tstring runid = arguments[ 0 ];

      // 012 Ȥ 0x12 ȤݤʤΤǵĤʤ
      if ( runid.size() != 1 && runid[ 0 ] == '0' ) {
        Tcerr << "TRunStartCommand::Execute: invalid ID" << Tendl;
        return;
      }

      //Ϥɤå
      for ( Tsize_t i = 0; i < runid.size(); i ++ ) {
        if ( isdigit( runid[ i ] ) == 0 ) {
          //ʳޤФʤ
          Tcerr << "TRunStartCommand::Execute: invalid ID" << Tendl;
          return;
        }
      }

      theRunManager -> StartRun( strtol( runid.c_str(), 0, 0 ) );
      return;
    } else {
      ShowCommandDetail();
      return;
    }
  }

  theRunManager -> StartRun();

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TRunStartCommand)
#endif
