// =====================================================================
/*!
//
//  \file TStreamableObject.hh
//  \brief This file contains the TStreamableObject class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TStreamableObject.hh,v 1.8 2004/03/07 10:30:30 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TStreamableObject.hh,v $
//  Revision 1.8  2004/03/07 10:30:30  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.7  2004/01/19 21:09:39  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.6  2003/12/06 10:59:11  goiwai
//  Serialize(Tvoid*) -> Serialize(const Tvoid*)ѹޤ.
//  Deserialize(const Tvoid*)ɲäޤ.
//  ȴμʤΤ,ХåեСեβǽޤ.
//  Reallocate()Ȥ褦ʻȤߤɬפǤ.
//
//  Revision 1.5  2003/11/24 06:55:41  goiwai
//  Size()貾۴ؿȤɲäޤ.
//
//  Revision 1.4  2003/11/03 08:35:12  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:42:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TSTREAMABLEOBJECT_HH
#define CLDAQ__TSTREAMABLEOBJECT_HH

#include "Tglobals.h"

class TOutputObjectStream;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TStreamableObject
// \brief This is the TStreamableObject class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TStreamableObject class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup DatarecordCategory
*/
class TStreamableObject
{

  protected:
    Tobject_t theObjectType;
    Tstring theID;

  public:
    TStreamableObject( Tobject_t objecttype, const Tstring& id );
    TStreamableObject( const TStreamableObject& right );

  public:
    Tobject_t GetObjectType() const;
    const Tstring& GetID() const;
    Tvoid SetObjectType( Tobject_t objecttype );
    Tvoid SetID( const Tstring& id );

  public:
    virtual const TStreamableObject& operator=( const TStreamableObject& right );
    virtual Tbool operator==( const TStreamableObject& right ) const;
    virtual Tbool operator!=( const TStreamableObject& right ) const;

  protected:
    virtual ~TStreamableObject();

  public:
    virtual Tint GetRecordSize() = 0;
    virtual Tint Record( TOutputObjectStream* output ) = 0;
    virtual Tvoid Clear() = 0;
    virtual Tint Serialize( const Tvoid* buffer ) = 0;
    virtual Tint Deserialize( const Tvoid* buffer ) = 0;
    virtual Tint Size() const = 0;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TStreamableObject,0)
#endif

};

inline Tobject_t TStreamableObject::GetObjectType() const
{
  return theObjectType;
}

inline const Tstring& TStreamableObject::GetID() const
{
  return theID;
}

inline Tvoid TStreamableObject::SetObjectType( Tobject_t objecttype )
{ 
  theObjectType = objecttype;
  return;
}

inline Tvoid TStreamableObject::SetID( const Tstring& id )
{
  theID = id;
  return;
}

#endif
