// =====================================================================
//  $Id: TSoftwareFlashAdcModule.cc,v 1.4 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TSoftwareFlashAdcModule.cc,v $
//  Revision 1.4  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSoftwareFlashAdcModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TRandomFlat.hh"
#include "TRandomEngine.hh"

static TRandomEngine _engine( (Tlong)time( 0 ) );
static TRandomFlat _register( _engine );

TSoftwareFlashAdcModule::TSoftwareFlashAdcModule( Tint nchannel, Tint nsampling )
  : TSoftwareModule( nchannel ), theNumberOfSampling( nsampling )
{
  setParameters();
  Update();
}

TSoftwareFlashAdcModule::TSoftwareFlashAdcModule( const TSoftwareFlashAdcModule& right )
  : TSoftwareModule( right ), theNumberOfSampling( right.theNumberOfSampling )
{;}

TSoftwareFlashAdcModule::~TSoftwareFlashAdcModule()
{;}

Tint TSoftwareFlashAdcModule::Clear()
{
  return theStatus = tStatusSuccess;
}

Tint TSoftwareFlashAdcModule::Update()
{
  fillValue();
  return theStatus;
}

Tint TSoftwareFlashAdcModule::Initialize()
{
  Clear();
  setParameters();
  return theStatus = tStatusSuccess;
}

Tvoid TSoftwareFlashAdcModule::FillData( TDataElement& element, Tint channel )
{
  TUshort* data = new TUshort[ theNumberOfSampling ];

  for ( Tint i = 0; i < theNumberOfSampling; i ++ ) {
    data[ i ] = (TUshort)_register.fireInt( 4096 );  //dummy data
  }

  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TSoftwareFlashAdcModule::FillData: invalid ID" << Tendl;
    theStatus = -EFAULT;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    element.FillData( data, tTypeUnsignedShort, theNumberOfSampling );
  }

  delete [] data;

  return;
}

const TSoftwareFlashAdcModule& TSoftwareFlashAdcModule::operator=( const TSoftwareFlashAdcModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theNumberOfSampling = right.theNumberOfSampling;
  return *this;
}

Tbool TSoftwareFlashAdcModule::operator==( const TSoftwareFlashAdcModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  ret &= ( theNumberOfSampling == right.theNumberOfSampling );
  return ret;
}

Tbool TSoftwareFlashAdcModule::operator!=( const TSoftwareFlashAdcModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret |= ( theNumberOfSampling != right.theNumberOfSampling );
  return ret;
}

Tvoid TSoftwareFlashAdcModule::setParameters()
{
  // under construction.
  return;
}

Tvoid TSoftwareFlashAdcModule::fillValue()
{
  // under construction.
  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TSoftwareFlashAdcModule)
#endif
