// =====================================================================
/*!
//
//  \file TSoftwareInterruptRegisterModule.hh
//  \brief This file contains the TSoftwareInterruptRegisterModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSoftwareInterruptRegisterModule.hh,v 1.6 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TSoftwareInterruptRegisterModule.hh,v $
//  Revision 1.6  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TSOFTWAREINTERRUPTREGISTERMODULE_HH
#define CLDAQ__TSOFTWAREINTERRUPTREGISTERMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSoftwareInterruptRegisterModule
// \brief This is the TSoftwareInterruptRegisterModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSoftwareInterruptRegisterModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TSoftwareInterruptRegisterModule
  : public TSoftwareModule
{

  private:
    Tint theInterruptRegister;
    Tint theInterruptMaskRegister;
    Tint theFrequency;

  public:
    TSoftwareInterruptRegisterModule( Tint nch = 2, Tint frequency = 1 );
    TSoftwareInterruptRegisterModule( const TSoftwareInterruptRegisterModule& right );
    ~TSoftwareInterruptRegisterModule();

  public:
    const TSoftwareInterruptRegisterModule& operator=( const TSoftwareInterruptRegisterModule& right );
    Tbool operator==( const TSoftwareInterruptRegisterModule& right ) const;
    Tbool operator!=( const TSoftwareInterruptRegisterModule& right ) const;

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tint ReadInterruptRegister();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tint GetInterruptRegister() const;
    Tint GetInterruptMaskRegister() const;
    Tint GetFrequency() const;
    Tvoid SetInterruptRegister( Tint val );
    Tvoid SetInterruptMaskRegister( Tint val );
    Tvoid SetFrequency( Tint frequency );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TSoftwareInterruptRegisterModule,0)
#endif

};

inline Tint TSoftwareInterruptRegisterModule::GetInterruptRegister() const
{
  return theInterruptRegister;
}

inline Tint TSoftwareInterruptRegisterModule::GetInterruptMaskRegister() const
{
  return theInterruptMaskRegister;
}

inline Tint TSoftwareInterruptRegisterModule::GetFrequency() const
{
  return theFrequency;
}

inline Tvoid TSoftwareInterruptRegisterModule::SetInterruptRegister( Tint val )
{
  theInterruptRegister = val;
  return;
}

inline Tvoid TSoftwareInterruptRegisterModule::SetInterruptMaskRegister( Tint val )
{
  theInterruptMaskRegister = val;
  return;
}

inline Tvoid TSoftwareInterruptRegisterModule::SetFrequency( Tint frequency )
{
  theFrequency = frequency;
  return;
}

#endif
