// =====================================================================
/*!
//
//  \file TObjectStream.hh
//  \brief This file contains the TObjectStream class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TObjectStream.hh,v 1.7 2004/03/07 10:30:32 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TObjectStream.hh,v $
//  Revision 1.7  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/12/06 10:56:19  goiwai
//  ե륿Ϣν Read(),Write()ͤνǤ.
//  Read()Write()쥳ɥ֤ޤ.
//  ե륿ƱͤǤ.
//  줾Υȥ꡼DataSizeΰǤ,ϰä쥳ɥ
//  Ǥʤäե䥽åȤʤɤΥˤʤޤ.쥳ɥ
//  פȤϸ¤ޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TOBJECTSTREAM_HH
#define CLDAQ__TOBJECTSTREAM_HH

#include "Tglobals.h"

class TObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TObjectStream
// \brief This is the TObjectStream class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TObjectStream class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TObjectStream
{

  protected:
    //! ȥ꡼ॿ(Τޤ)
    Tstream_t theStreamType;
    //! оݤΥǡ(쥳ɥȤϻʤΤǤ)
    Tint theDataSize;
    //! ľν(Read/Write)Τ
    Tint theLastDataSize;
    //! ޤǽǡιץ
    Tint theTotalDataSize;

  public:
    TObjectStream( Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TObjectStream();

  public:
    Tstream_t GetStreamType() const;
    Tint GetDataSize() const;
    Tint GetLastDataSize() const;
    Tint GetTotalDataSize() const;
    Tvoid SetStreamType( Tstream_t streamtype );
    Tvoid SetDataSize( Tint datasize );
    Tvoid SetLastDataSize( Tint datasize );
    Tvoid SetTotalDataSize( Tint datasize );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TObjectStream,0)
#endif

};

inline Tint TObjectStream::GetDataSize() const
{
  return theDataSize;
}

inline Tint TObjectStream::GetLastDataSize() const
{
  return theLastDataSize;
}

inline Tvoid TObjectStream::SetDataSize( Tint datasize )
{
  theDataSize = datasize;
  return;
}

inline Tvoid TObjectStream::SetLastDataSize( Tint datasize )
{
  theLastDataSize = datasize;
  return;
}

inline Tstream_t TObjectStream::GetStreamType() const
{
  return theStreamType;
}

inline Tvoid TObjectStream::SetStreamType( Tstream_t streamtype )
{
  theStreamType = streamtype;
  return;
}

inline Tint TObjectStream::GetTotalDataSize() const
{
  return theTotalDataSize;
}

inline Tvoid TObjectStream::SetTotalDataSize( Tint datasize )
{
  theTotalDataSize = datasize;
  return;
}

#endif
