// =====================================================================
//  $Id: TOutputObjectSharedMemory.cc,v 1.7 2004/06/24 15:15:25 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TOutputObjectSharedMemory.cc,v $
//  Revision 1.7  2004/06/24 15:15:25  goiwai
//  ѹ
//  Tcout,Tcerr,TlogХåեͳˤ
//  ĤexternTlog,Tcout,Tcerr,Tinfo...Tcritʤɽϴط
//
//  Revision 1.6  2004/03/07 16:52:34  goiwai
//  __CLDAQ_ZLIB_USEץץåΰ֤äȤ餷Ǥ
//
//  Revision 1.5  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.4  2003/12/06 10:56:19  goiwai
//  ե륿Ϣν Read(),Write()ͤνǤ.
//  Read()Write()쥳ɥ֤ޤ.
//  ե륿ƱͤǤ.
//  줾Υȥ꡼DataSizeΰǤ,ϰä쥳ɥ
//  Ǥʤäե䥽åȤʤɤΥˤʤޤ.쥳ɥ
//  פȤϸ¤ޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectSharedMemory.hh"
#include "TStreamableObject.hh"
#include "TOutputObjectFilter.hh"

TOutputObjectSharedMemory::TOutputObjectSharedMemory( Tint memsize, Tint maxevt )
  : TObjectSharedMemory( memsize, maxevt ),
    TOutputObjectStream( tSharedMemoryStream )
{
  signal( SIGINT, TOutputObjectSharedMemory::catchSignal );
  signal( SIGSEGV, TOutputObjectSharedMemory::catchSignal );
}

TOutputObjectSharedMemory::TOutputObjectSharedMemory( TOutputObjectFilter* filter, Tint memsize, Tint maxevt )
  : TObjectSharedMemory( memsize, maxevt ),
    TOutputObjectStream( filter, tSharedMemoryStream )
{
  signal( SIGINT, TOutputObjectSharedMemory::catchSignal );
  signal( SIGSEGV, TOutputObjectSharedMemory::catchSignal );
}

TOutputObjectSharedMemory::~TOutputObjectSharedMemory()
{
  Detach();
  Remove();
}

Tint TOutputObjectSharedMemory::Write( TStreamableObject& object )
{
  if ( HasFilter() ) {
    return theObjectFilter -> Filtering( object, this );
  }

  SetReadable( Tfalse );

  theLastDataSize = theDataSize;
  theDataSize = 0;

  if ( theCurrentPositionOfMemorySpace == theMaxEvent - 1 ) {
    // return to top
    theAddress = theBaseAddress;
    theCurrentPositionOfMemorySpace = 0;
  }
    
  theDataSize = object.Record( this );

  if ( theDataSize > 0 ) {
    theCurrentPositionOfMemorySpace ++;
  }

  //( (Tchar*)theAddress ) += theDataSize;

  SetReadable( Ttrue );
  theTotalDataSize += theDataSize;
  return theDataSize;
}

Tvoid TOutputObjectSharedMemory::catchSignal( Tint sigid )
{
  Tstring head = "TOutputObjectSharedMemory::catchSignal: ";
  Tcout << head << "get signal " << sigid << "." << Tendl;
  Tcout << head << "detach/remove IPC resources." << Tendl;
  TObjectSharedMemory::GetObjectSharedMemory() -> Detach();
  TObjectSharedMemory::GetObjectSharedMemory() -> Remove();

//   TRunManager* manager = TRunManager::GetRunManager();
//   if ( manager ) {
//     Tcout << head << "terminate RunManager by force." << Tendl;
//     manager -> GetUserInterface() -> ExecuteCommand( "exit" );
//     delete manager;
//   }

  Tcout << head << "terminate by force." << Tendl;
  exit( EXIT_SUCCESS );

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TOutputObjectSharedMemory)
#endif
