// =====================================================================
/*!
//
//  \file TReadoutBookDefinition.hh
//  \brief This file contains the TReadoutBookDefinition class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TReadoutBookDefinition.hh,v 1.6 2004/03/07 10:30:33 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TReadoutBookDefinition.hh,v $
//  Revision 1.6  2004/03/07 10:30:33  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:42  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TREADOUTBOOKDEFINITION_HH
#define CLDAQ__TREADOUTBOOKDEFINITION_HH

#include "Tglobals.h"

class TReadoutBook;
class TCrate;
class TRunManager;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TReadoutBookDefinition
// \brief This is the TReadoutBookDefinition class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TReadoutBookDefinition class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ReadoutCategory
*/
class TReadoutBookDefinition
{

  protected:
    TRunManager* theRunManager;
    TCrate* theCrate;

  public:
    TReadoutBookDefinition( TRunManager* manager = 0 );
    virtual ~TReadoutBookDefinition();

  public:
    virtual TReadoutBook* Define() = 0;

  public:
    TRunManager* GetRunManager() const;
    Tvoid SetRunManager( TRunManager* manager );
    TCrate* GetCrate() const;
    Tvoid SetCrate( TCrate* crate );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TReadoutBookDefinition,0)
#endif

};

inline TRunManager* TReadoutBookDefinition::GetRunManager() const
{
  return theRunManager;
}

inline Tvoid TReadoutBookDefinition::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

inline TCrate* TReadoutBookDefinition::GetCrate() const
{
  return theCrate;
}

inline Tvoid TReadoutBookDefinition::SetCrate( TCrate* crate )
{
  theCrate = crate;
  return;
}

#endif
