// =====================================================================
/*!
//
//  \file TRunManager.hh
//  \brief This file contains the TRunManager class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TRunManager.hh,v 1.22 2004/09/01 08:08:36 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TRunManager.hh,v $
//  Revision 1.22  2004/09/01 08:08:36  goiwai
//  ҥץclose褦ˤ
//
//  Revision 1.21  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.20  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.19  2003/11/03 11:46:42  goiwai
//  Ȥäɲä,˰ΤǤޤ...
//
//  Revision 1.18  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.17  2003/10/06 17:02:45  goiwai
//  *** empty log message ***
//
//  Revision 1.16  2003/07/30 17:46:19  goiwai
//  Tint GetRunID() const;
//  Tvoid SetRunID( Tint id );
//  ɲäޤ.
//
//  Revision 1.15  2003/07/30 16:20:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TRUNMANAGER_HH
#define CLDAQ__TRUNMANAGER_HH

#include "Tglobals.h"
#include "TRun.hh"
#include "TSystemTimer.hh"
#include "TSystemClock.hh"
#include "TEnvironmentVariableTable.hh"

class TUserInterface;
class TCommand;
class TSystemAction;
class TRunAction;
class TEventAction;
class TEventManager;
class TSoftwareRunInformationModule;
class TAnalysisManager;
class TSystemTimer;
class TReadoutBookDefinition;
class TReadoutBook;
class TCrateDefinition;
class TCrate;


/*!
// \example terminal.cc
//
// äȤñʥޥ͡㡼λǤ.
//
*/

/*!
// \example bt00.cc
//
// ޥ͡㡼λǤ.
//
*/

/*!
// \example rs00.cc
//
// ޥ͡㡼λǤ.
//
*/

/*!
// \example rs01.cc
//
// ޥ͡㡼λǤ.
//
*/

/*!
// \example sw00.cc
//
// ޥ͡㡼λǤ.
//
*/

/*!
// \example st00.cc
//
// ޥ͡㡼λǤ.
//
*/

/*!
// \example st01.cc
//
// ޥ͡㡼λǤ.
//
*/

/*!
// \example st02.cc
//
// ޥ͡㡼λǤ.
//
*/

/*!
// \class TRunManager
// \brief ϥ뤿Υ饹Ǥ.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// TRunManager饹ƤDAQץꥱɬפȤʤޤ.
// DAQץꥱ󤫤饤󥹥󥷥Ȥ줿ƤΥ֥Ȥ
// 黲ȤǤ褦ˤʤäƤޤ.
// ޤ륷󥰥ȥ󥯥饹Ǥ.
// Ƥξ,Υ饹ѾɬפϤʤȻפޤ,⤷
// ʣ(뤤ü)ư򤵤ϤΥ饹Ѿ,
// Ƽдؿ򥪡С饤ɤƤ.
//
// \todo ҥץưǤ褦ˤ.
// \todo åɤưǤ褦ˤ.
// \bug ¹Ի֤ɽޥʥˤʤäƤޤ.
// \ingroup RunCategory
*/
class TRunManager
{

  protected:
    //! ޥ͡㡼ȤؤΥݥ
    static TRunManager* theRunManager;

  protected:
    //! ޥ͡㡼ξ
    Tstatus_t theStatus;

    //! ¹Υ
    TRun theRun;

    //! 
    TSystemAction* theSystemAction;

    //! 
    TRunAction* theRunAction;

    //! ٥ȥޥ͡㡼ؤΥݥ
    TEventManager* theEventManager;

    //! 
    TUserInterface* theUserInterface;

    //! 
    Tthread_t theThreadOfEventLoop;

    //! 
    TSoftwareRunInformationModule* theRunInformationModule;

    //! 
    TAnalysisManager* theAnalysisManager;

    //! 
    TSystemTimer theRunTimer;

    //! 
    TSystemClock theRunClock;

    //! 
    TReadoutBookDefinition* theReadoutBookDefinition;

    //! 
    TReadoutBook* theReadoutBook;

    //! 
    TCrateDefinition* theCrateDefinition;

    //! 
    TCrate* theCrate;

    //! 
    TEnvironmentVariableTable theEnvironmentVariableTable;

    //! 
    Tint theEventLimit;

  public:
    //! TUserInterface饹Ѿ֥ȤϤƲ.
    /*!
    // 󥹥ȥ饯ˤTUserInterface饹Ѿ֥Ȥ
    // newϤƲ.
    // ά,TTerminalUserInterfaceѤޤ.
    */
    TRunManager( TUserInterface* ui = 0 );

    //! ɬǸ˸ƤФʤƤϤʤޤ.
    virtual ~TRunManager();

  public:
    //! theUserInterfaceؤΥݥ󥿤
    TUserInterface* GetUserInterface() const;

    //! theRunؤλȤ
    const TRun& GetRun() const;

    //! theRunؤλȤ
    TRun& GetRun();

    //! theRunID
    Tint GetRunID() const;

    //! theRunIDѹ
    Tvoid SetRunID( Tint id );

    //! theSystemActionؤΥݥ󥿤
    TSystemAction* GetSystemAction() const;

    //! theRunActionؤΥݥ󥿤
    TRunAction* GetRunAction() const;

    //! theEventManagerؤΥݥ󥿤
    TEventManager* GetEventManager() const;

    //! theUserInterfaceꤹ
    Tvoid SetUserInterface( TUserInterface* ui );

    //! ޥɤϿԤʤ
    Tint SetUserCommand( TCommand* command );

    //! theRunѹ
    Tvoid SetRun( const TRun& run );

    //! theSystemActionꤹ
    Tvoid SetSystemAction( TSystemAction* action );

    //! theRunActionꤹ
    Tvoid SetRunAction( TRunAction* action );

    //! theEventActionꤹ
    Tvoid SetEventAction( TEventAction* action );

    //! theEventManagerꤹ
    Tvoid SetEventManager( TEventManager* manager );

    //! theStatus 
    Tstatus_t GetStatus() const;

    //! theStatus ѹ
    Tvoid SetStatus( Tstatus_t status );

    //! ٥ȥ롼פ¹ԤƤ륹åɤID(theThreadOfEventLoop)
    Tthread_t GetThreadOfEventLoop() const;

    //! ٥ȥ롼פ¹ԤƤ륹åɤID(theThreadOfEventLoop)ѹ
    Tvoid SetThreadOfEventLoop( Tthread_t thread );

    //! theRunInformationModuleؤΥݥ󥿤
    TSoftwareRunInformationModule* GetRunInformationModule() const;

    //! theAnalysisManagerؤΥݥ󥿤
    TAnalysisManager* GetAnalysisManager() const;

    //! theRunTimerؤλȤ
    const TSystemTimer& GetRunTimer() const;

    //! theRunTimerؤλȤ
    TSystemTimer& GetRunTimer();

    //! theRunTimerѹ
    Tvoid SetRunTimer( const TSystemTimer& timer );

    //! theRunClockؤλȤ
    const TSystemClock& GetRunClock() const;

    //! theRunClockؤλȤ
    TSystemClock& GetRunClock();

    //! theRunClockѹ
    Tvoid SetRunClock( const TSystemClock& clock );

    //! theReadoutBookDefinition
    TReadoutBookDefinition* GetReadoutBookDefinition() const;

    //! theReadoutBook
    TReadoutBook* GetReadoutBook() const;

    //! 
    TCrateDefinition* GetCrateDefinition() const;

    //! 
    TCrate* GetCrate() const;

    //! 
    Tvoid SetReadoutBookDefinition( TReadoutBookDefinition* definition );

    //! 
    Tvoid SetCrateDefinition( TCrateDefinition* definition );

    //! 
    const TEnvironmentVariableTable& GetEnvironmentVariableTable() const;

    //! 
    TEnvironmentVariableTable& GetEnvironmentVariableTable();

    //! 
    Tvoid SetEnvironmentVariableTable( const TEnvironmentVariableTable& table );

    //! 
    Tint GetEventLimit() const;

    //! 
    Tvoid SetEventLimit( Tint nevents );

  public:
    //! 
    virtual Tvoid SessionStart();

    //! 
    virtual Tvoid ShowStatus() const;

    //! 
    virtual Tvoid PopupLogo() const;

    //! 
    virtual Tvoid PopdownLogo() const;

    //! 
    virtual Tvoid PrintAuthorInformation( Tostream& tos = Tcout ) const;

    //! 
    virtual Tvoid ShutdownRun();

    //! 
    virtual Tvoid StartRun();

    //! 
    virtual Tvoid StartRun( Tint runid );

    //! 
    virtual Tvoid StopRun();

    //! 
    virtual Tvoid SuspendRun();

    //! 
    virtual Tvoid ResumeRun();

    //! 
    virtual Tvoid SetRunInformationModule( TSoftwareRunInformationModule* module );

    //! 
    virtual Tvoid SetRunInformationModule( const Tstring& id );

    //! 
    virtual Tvoid SetRunInformationModule( Tint slot );

    //! 
    virtual Tvoid SetAnalysisManager( TAnalysisManager* manager );

  public:
    //! ޥ͡㡼ؤΥݥ󥿤
    static TRunManager* GetRunManager();

  protected:
    //! 
    static Tvoid* doEventLoop( Tvoid* arguments );

    //! 
    static Tvoid catchAlarmSignal( Tint sigid );

  public:
    //! 
    virtual Tvoid GoEventLoop();

    //! 
    virtual Tvoid WaitReturnFromEventLoop();

  protected:
    //! 
    virtual TstringList divide( const Tstring& input ) const;

    //! 
    virtual Tvoid installDefaultCommand();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TRunManager,0)
#endif

};

inline TRunManager* TRunManager::GetRunManager()
{
  return theRunManager;
}

inline TUserInterface* TRunManager::GetUserInterface() const
{
  return theUserInterface;
}

inline Tvoid TRunManager::SetRun( const TRun& run )
{
  theRun = run;
  return;
}

inline const TRun& TRunManager::GetRun() const
{
  return theRun;
}

inline TRun& TRunManager::GetRun()
{
  return theRun;
}

inline Tint TRunManager::GetRunID() const
{
  return theRun.GetRunID();
}

inline Tvoid TRunManager::SetRunID( Tint id )
{
  theRun.SetRunID( id );
  return;
}

inline TSystemAction* TRunManager::GetSystemAction() const
{
  return theSystemAction;
}

inline TRunAction* TRunManager::GetRunAction() const
{
  return theRunAction;
}

inline TEventManager* TRunManager::GetEventManager() const
{
  return theEventManager;
}

inline Tstatus_t TRunManager::GetStatus() const
{
  return theStatus;
}

inline Tvoid TRunManager::SetStatus( Tstatus_t status )
{
  theStatus = status;
  return;
}

inline Tthread_t TRunManager::GetThreadOfEventLoop() const
{
  return theThreadOfEventLoop;
}

inline Tvoid TRunManager::SetThreadOfEventLoop( Tthread_t thread )
{
  theThreadOfEventLoop = thread;
  return;
}

inline TSoftwareRunInformationModule* TRunManager::GetRunInformationModule() const
{
  return theRunInformationModule;
}

inline TAnalysisManager* TRunManager::GetAnalysisManager() const
{
  return theAnalysisManager;
}

inline const TSystemTimer& TRunManager::GetRunTimer() const
{
  return theRunTimer;
}

inline TSystemTimer& TRunManager::GetRunTimer()
{
  return theRunTimer;
}

inline TReadoutBookDefinition* TRunManager::GetReadoutBookDefinition() const
{
  return theReadoutBookDefinition;
}

inline TReadoutBook* TRunManager::GetReadoutBook() const
{
  return theReadoutBook;
}

inline TCrateDefinition* TRunManager::GetCrateDefinition() const
{
  return theCrateDefinition;
}

inline TCrate* TRunManager::GetCrate() const
{
  return theCrate;
}

inline Tvoid TRunManager::SetRunTimer( const TSystemTimer& timer )
{
  theRunTimer = timer;
  return;
}

inline const TEnvironmentVariableTable& TRunManager::GetEnvironmentVariableTable() const
{
  return theEnvironmentVariableTable;
}

inline TEnvironmentVariableTable& TRunManager::GetEnvironmentVariableTable()
{
  return theEnvironmentVariableTable;
}

inline Tvoid TRunManager::SetEnvironmentVariableTable( const TEnvironmentVariableTable& table )
{
  theEnvironmentVariableTable = table;
  return;
}

inline const TSystemClock& TRunManager::GetRunClock() const
{
  return theRunClock;
}

inline TSystemClock& TRunManager::GetRunClock()
{
  return theRunClock;
}

inline Tvoid TRunManager::SetRunClock( const TSystemClock& clock )
{
  theRunClock = clock;
  return;
}

inline Tint TRunManager::GetEventLimit() const
{
  return theEventLimit;
}

inline Tvoid TRunManager::SetEventLimit( Tint nevents )
{
  theEventLimit = nevents;
  return;
}

#endif
