// =====================================================================
/*!
//
//  \file TOptionMap.hh
//  \brief This file contains the TOptionMap class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TOptionMap.hh,v 1.4 2004/03/07 10:30:34 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: TOptionMap.hh,v $
//  Revision 1.4  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.2  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.1  2003/10/06 16:32:25  goiwai
//  GNUΰñˤľŪ˲᤹뤿ʤǤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TOPTIONMAP_HH
#define CLDAQ__TOPTIONMAP_HH

#include "Tglobals.h"
#include "TOption.hh"
#include "TOptionList.hh"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TOptionMap
// \brief This is the TOptionMap class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TOptionMap class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TOptionMap
{

  private:
    TOptionList theOptionList;
    TstringList theParameterList;

  public:
    TOptionMap();
    TOptionMap( const TOptionMap& right );
    ~TOptionMap();

  public:
    const TOptionMap& operator=( const TOptionMap& right );

  public:
    friend Tostream& operator<<( Tostream& tos, const TOptionMap& right );

  public:
    Tvoid AddOption( const TOption& option, const Tstring& param = "" );
    Tbool HasOption( const TOption& option ) const;
    Tbool HasOption( const Tstring& option ) const;
    Tstring GetParameter( Tint index ) const;
    Tstring GetParameter( const Tstring& optionname ) const;
    Tstring GetParameter( const TOption& option ) const;

  public:
    const TOptionList& GetOptionList() const;
    TOptionList& GetOptionList();
    const TstringList& GetParameterList() const;
    TstringList GetParameterList();
    Tvoid SetOptionList( const TOptionList& options );
    Tvoid SetParameterList( const TstringList& params );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TOptionMap,0)
#endif

};

inline const TOptionList& TOptionMap::GetOptionList() const
{
  return theOptionList;
}

inline TOptionList& TOptionMap::GetOptionList()
{
  return theOptionList;
}

inline const TstringList& TOptionMap::GetParameterList() const
{
  return theParameterList;
}

inline TstringList TOptionMap::GetParameterList()
{
  return theParameterList;
}

inline Tvoid TOptionMap::SetOptionList( const TOptionList& options )
{
  theOptionList = options;
  return;
}

inline Tvoid TOptionMap::SetParameterList( const TstringList& params )
{
  theParameterList = params;
  return;
}

#endif
