// =====================================================================
//  $Id: ifilez.cc,v 1.1 2003/12/23 18:48:18 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: ifilez.cc,v $
//  Revision 1.1  2003/12/23 18:48:18  goiwai
//  TOutputObjectFileZ/TInputObjectFileZ ΥƥȥץǤ.
//  ifilter/ofilterȤäƤ뤳ȤƱ,ɤιԿϾޤ.
//  ⤦ͻҤߤƾŪˤϤǥեȤϤˤ褦Ȼפޤ.
//  쥳ɤ˥ե륿IDĤʤ㤤ʤäʤ..
//
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectFileZ.hh"
#include "TBenchmark.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TArgument arg( argc, argv );
  if ( arg.GetNumberOfElements() != 1 || !isexist( arg[ 0 ] ) ) {
    arg.ShowUsage();
  }
  const Tstring filename = arg[ 0 ];

  TInputObjectFileZ ifilez( filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ( ifilez.Read( record ) ) != 0 ) {
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifilez.GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  return 0;
}
