// =====================================================================
//  $Id: sm2400.cc,v 1.3 2003/10/06 04:03:39 goiwai Exp $
//  $Name: CLDAQ-1-14-05 $
//  $Log: sm2400.cc,v $
//  Revision 1.3  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRs232cKeithley2400Module.hh"
#include "TDataElement.hh"
#include "TBenchmark.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TOption opevent( "number-of-events", 1 );
  TOption opdevice( "device", "d", 1, "/dev/ttyS0 is typical on linux system" );
  const Tint noption = 2;
  TOption options[ noption ] = { opevent, opdevice };
  TArgument arg( argc, argv, TOptionTable( options, noption ) );

  Tstring devpath = "/dev/ttyS0";
  if ( arg.HasOption( opdevice ) ) {
    devpath = arg[ opdevice ];
  }

  Tint nevent = 10;
  if ( arg.HasOption( opevent ) ) {
    nevent = arg.GetIntegerParameter( opevent );
  }


  TRs232cKeithley2400Module sm2400;
  sm2400.Initialize();
  TDataElement e;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    sm2400.FillData( e, 0 );
    sm2400.Clear();
    Tcout << e << Tendl;
    sleep( 1 );
  }
  sm2400.Close();
  bench.Stop();
  Tcout << bench << Tendl;
  return 0;
}
