// =====================================================================
//  $Id: Rs01CrateDefinition.cc,v 1.4 2003/10/18 15:58:02 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: Rs01CrateDefinition.cc,v $
//  Revision 1.4  2003/10/18 15:58:02  goiwai
//  ⥸塼ʳƱ쥰롼פˤޤ.
//
//  Revision 1.3  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:14:41  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TEnvironmentVariableTable.hh"
#include "TRs232cKeithley7702Module.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "TRunInformationTable.hh"
#include "Rs01CrateDefinition.hh"


Rs01CrateDefinition::Rs01CrateDefinition()
  : TCrateDefinition()
{;}

Rs01CrateDefinition::~Rs01CrateDefinition()
{;}

TCrate* Rs01CrateDefinition::Define()
{
  Tstring group = "initialize at begin of run";

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring dev = envtable.GetEnvironmentValue( "RS01_KEITHLEY_DEVICE" );
  Tint npin = envtable.GetIntegerValue( "RS01_KEITHLEY_CHANNEL" );


  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "OPERATOR", tInfoFreeValue ) );
  TstringList selectlist;
  selectlist.push_back( "REAL RUN" );
  selectlist.push_back( "TEST RUN" );
  infolist.push_back( TRunInformation( "RUN TYPE", selectlist ) );
  infolist.push_back( TRunInformation( "COMMENT", tInfoFreeText ) );
  TRunInformationTable table( infolist );


  TCrate* crate = new TCrate();
  TSoftwareRunInformationModule* runinfo =
    new TSoftwareRunInformationModule( table );
  crate -> InstallModule( runinfo, "RUN INFO" );
  theRunManager -> SetRunInformationModule( runinfo );

  crate -> InstallModule( new TRs232cKeithley7702Module( dev ), "MODEL 7702", group );
  crate -> InstallModule( new TSoftwareClockModule(), "CLOCK", group );

  for ( Tint i = 0; i < npin; i ++ ) {
    Tstring modid = "TIMER" + itostr( i, 2 );
    crate -> InstallModule( new TSoftwareTimerModule(), modid, group );
  }

  crate -> InstallModule( new TSoftwareScalerModule( 1 ), "EVENT ID", group );
  return crate;
}
