// =====================================================================
//  $Id: DaqCrateDefinition.cc,v 1.1 2006/02/15 07:04:51 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: DaqCrateDefinition.cc,v $
//  Revision 1.1  2006/02/15 07:04:51  goiwai
//  ɥѤ˺Ǥñ꥽եȥDAQץޤ
//
// =====================================================================
#include "TCrate.hh"
#include "DaqCrateDefinition.hh"

#include "TSoftwareScalerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareAdcModule.hh"
#include "TSoftwareInterruptRegisterModule.hh"

DaqCrateDefinition::DaqCrateDefinition()
  : TCrateDefinition()
{;}

DaqCrateDefinition::~DaqCrateDefinition()
{;}

TCrate* DaqCrateDefinition::Define()
{
  TCrate* crate = new TCrate();

  // ΤŬʥĤƥ⥸塼򥯥졼Ȥ˥󥹥ȡ
  crate->InstallModule(new TSoftwareScalerModule(), "SCALER");
  crate->InstallModule(new TSoftwareClockModule(), "CLOCK");
  crate->InstallModule(new TSoftwareTimerModule(), "TIMER");
  crate->InstallModule(new TSoftwareAdcModule(), "ADC");
  crate->InstallModule(new TSoftwareInterruptRegisterModule(), "INTERRUPT");

  return crate;
}
