// =====================================================================
//  $Id: St01DarkDataSetInterface.hh,v 1.4 2004/01/19 21:10:28 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: St01DarkDataSetInterface.hh,v $
//  Revision 1.4  2004/01/19 21:10:28  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.3  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__ST01SINGLEPIXELINTERFACE_HH
#define CLDAQ__ST01SINGLEPIXELINTERFACE_HH

#include "Tglobals.h"
#include "St01DarkDataSetList.hh"
#include "TEnvironmentVariableTable.hh"

class St01DarkDataSetInterface
{

  private:
    St01DarkDataSetList theDarkDataSetList;
    TEnvironmentVariableTable theEnvironmentVariableTable;
    Tint theXrayPeakCount;
    Tint theXrayPeakElectron;

  public:
    St01DarkDataSetInterface( const Tstring& rcfile );
    ~St01DarkDataSetInterface();

  public:
    const St01DarkDataSetList& GetDarkDataSetList() const;
    St01DarkDataSetList& GetDarkDataSetList();
    Tint GetXrayPeakCount() const;
    Tint GetXrayPeakElectron() const;
    Tvoid SetDarkDataSetList( const St01DarkDataSetList& list );
    Tvoid SetXrayPeakCount( Tint adc );
    Tvoid SetXrayPeakElectron( Tint e );

};

inline const St01DarkDataSetList& St01DarkDataSetInterface::GetDarkDataSetList() const
{
  return theDarkDataSetList;
}

inline St01DarkDataSetList& St01DarkDataSetInterface::GetDarkDataSetList()
{
  return theDarkDataSetList;
}

inline Tint St01DarkDataSetInterface::GetXrayPeakCount() const
{
  return theXrayPeakCount;
}

inline Tint St01DarkDataSetInterface::GetXrayPeakElectron() const
{
  return theXrayPeakElectron;
}

inline Tvoid St01DarkDataSetInterface::SetDarkDataSetList( const St01DarkDataSetList& list )
{
  theDarkDataSetList = list;
  return;
}

inline Tvoid St01DarkDataSetInterface::SetXrayPeakCount( Tint adc )
{
  theXrayPeakCount = adc;
  return;
}

inline Tvoid St01DarkDataSetInterface::SetXrayPeakElectron( Tint e )
{
  theXrayPeakElectron = e;
  return;
}

#endif
