// =====================================================================
//  $Id: TExecuteCommand.cc,v 1.7 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: TExecuteCommand.cc,v $
//  Revision 1.7  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2003/11/25 19:13:10  goiwai
//  *** empty log message ***
//
//  Revision 1.5  2003/11/25 14:39:45  goiwai
//  mutex¾椷ʤȤޤ.äǤ.
//
//  Revision 1.4  2003/11/25 13:43:22  goiwai
//  Ȥꤢ,롼׻äޤ.
//  ޤ­ưޤ.ä˥꡼פ褦ʥޥɤФ.
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TExecuteCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring _name = "/system/execute";
static const Tstring _desc =
"read a macro file, execute."
"\n"
"1st argument is filename, 2nd argument(omiitable) is a number of loop, you wish."
"\n"
"CLDAQ> /system/execute sample.macro"
"\n"
"CLDAQ> /system/execute sample.macro 100";

TExecuteCommand::TExecuteCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc ), theMacroFileParser()
{;}

TExecuteCommand::~TExecuteCommand()
{;}

Tvoid TExecuteCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  static const Tstring head = "TExecuteCommand::Execute: ";

  if ( ui ) {
    if ( arguments.empty() ) {
      ShowCommandDetail();
    } else if ( arguments.size() == 1 ) {
      Tstring filename = arguments[ 0 ];
      doExecute( ui, filename );
    } else if ( arguments.size() == 2 ) {
      Tstring filename = arguments[ 0 ];
      Tint nloop = strtol( arguments[ 1 ].c_str(), 0, 0 );
      doExecute( ui, filename, nloop );
    } else {
      Tcerr << head << "number of arguments should be 1 or 2." << Tendl;
      ShowCommandDetail();
    }
  } else {
    Tcerr << head << "UserInterface doesn't exist." << Tendl;
  }
  return;
}

//ޤȤ˵ǽ
Tvoid TExecuteCommand::doExecute( TUserInterface* ui, const Tstring& filename, Tint nloop )
{
  TMacroFileParser macro( filename );
  TstringList readbuf;

  for ( Tint i = 0; i < nloop; i ++ ) {
    macro.Open();
    while ( macro.IsSuccess() ) {
      readbuf = macro.ReadLine();
      if ( macro.IsExecutable( readbuf ) ) {
	Tstring command = macro.GetCommand( readbuf );
	TstringList args = macro.GetArguments( readbuf );
	ui -> ExecuteCommand( command, args );


        //TODO
        //ޥ¹ԤȥƱʤȤʤ󤫤?
        //CLDAQ_DEBUG(command.c_str());
        //for ( Tsize_t i = 0; i < args.size(); i ++ ) {
        //CLDAQ_DEBUG(args[i].c_str());
        //}
        // mutex ¾椷ʤȤ⤷ʤǤ
        //usleep(1000*1000);  //sleep ϤȤǤ
      }
    }
  }
  macro.Close();

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TExecuteCommand)
#endif
