// =====================================================================
//  $Id: iostream.cc,v 1.1 2004/06/28 04:49:28 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: iostream.cc,v $
//  Revision 1.1  2004/06/28 04:49:28  goiwai
//  Tcout,Tcerr,TclogλȤΥץǤ
//
// =====================================================================
#include "TSystemLogging.hh"
#include "TSystemAction.hh"
#include "TRunAction.hh"
#include "TBenchmark.hh"
#include "TRunManager.hh"

class MySystemAction
  : public TSystemAction
{
  public:
    inline Tvoid CatchStandardOut( Tstring message ) {
      std::cout << "STDOUT: " << message << std::flush;
      return;
    }
    inline Tvoid CatchStandardError( Tstring message ) {
      std::cerr << "STDERR: " << message << std::flush;
      return;
    }
    inline Tvoid CatchLog( Tstring message, Tint level ) {
      switch ( level ) {
        case TSystemLogging::EMERG:
          Temerg << message << Tflush;
          break;
        case TSystemLogging::ALERT:
          Talert << message << Tflush;
          break;
        case TSystemLogging::CRIT:
          Tcrit << message << Tflush;
          break;
        case TSystemLogging::ERROR:
          Terror << message << Tflush;
          break;
        case TSystemLogging::WARNING:
          Twarn << message << Tflush;
          break;
        case TSystemLogging::NOTICE:
          Tnotice << message << Tflush;
          break;
        case TSystemLogging::INFO:
          Tinfo << message << Tflush;
          break;
        case TSystemLogging::DEBUG:
          Tdebug << message << Tflush;
          break;
        default:
          Tinfo << message << Tflush;
          break;
      }
      return;
    }
};

int main( int argc, char** argv, char** envv )
{
  TBenchmark bench;
  bench.Start();

  TRunManager* manager = new TRunManager();
  manager -> SetSystemAction( new MySystemAction() );
  Tcout << "This is standard output." << Tendl;
  Tcout << "This is standard error." << Tendl;
  Tclog.SetLogLevel( TSystemLogging::INFO );
  Tclog << "This is log message, see \"/var/log/messages\"." << Tendl;
  delete manager;

  bench.Stop();
  Tcout << bench << Tendl;

  return 0;
}
