// =====================================================================
//  $Id: Rs01EventAction.cc,v 1.1 2003/07/06 03:21:34 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TEvent.hh"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs01EventAction.hh"
#include "Rs01RunAction.hh"
#include "Rs01RunSummary.hh"

Rs01EventAction::Rs01EventAction()
{;}

Rs01EventAction::~Rs01EventAction()
{;}

TReadoutList* Rs01EventAction::WaitEvent()
{
  return( theReadoutBook -> GetReadoutList( "EVENT" ) );
}

Tvoid Rs01EventAction::EndOfEventAction( TEvent& anEvent )
{
  Rs01RunAction* action =
    (Rs01RunAction*)( theRunManager -> GetRunAction() );
  action -> GetOutputFile() -> Write( anEvent.GetDataRecord() );

  Rs01RunSummary* summary = action -> GetRunSummary();
  Tint nev = summary -> GetNumberOfEvents();
  summary -> SetNumberOfEvents( ++ nev );

  theCrate -> GetModule( "EVENT ID" ) -> Update();
  return;
}
