// =====================================================================
//  $Id: OFFspexit.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "St00OfflineDarkAverageMap.hh"
#include "St00OfflineRmsMap.hh"
#include "St00SinglePixelInterface.hh"
#include "St00SinglePixelList.hh"
#include "St00DataRecordConversion.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 4 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <dark> <source> <output>" << Tendl;
    return( -1 );
  }

  TApplication* theApplication = new TApplication( "root-analyser", 0, 0 );
  gROOT -> Reset( 0 );
  gStyle -> SetStatColor( 42 );
  gStyle -> SetTitleColor( 42 );
  gStyle -> SetFrameFillColor( 21 );
  gStyle -> SetFrameFillStyle( 1 );
  gStyle -> SetMarkerStyle( 7 );
  gStyle -> SetFuncColor( 4 );
  gStyle -> SetOptStat( 1111110 );
  gStyle -> SetOptFit( 1111 );
  gStyle -> SetPadGridX( kTRUE );
  gStyle -> SetPadGridY( kTRUE );
  TCanvas cv( "CVfadc", "Pentland MPX201A", 900, 600 );
  cv.Divide( 2, 2 );
  TH1D signal( "signal", "SIGNAL", 100, 0.0, 1000.0 );
  TH1D dark( "dark", "DARK", 50, -50.0, 50.0 );
  TH1D rms( "rms", "RMS", 20, 0.0, 50.0 );
  signal.SetFillColor( 45 );
  dark.SetFillColor( 45 );
  rms.SetFillColor( 45 );




  Tstring drkf = argv[ 1 ];
  Tstring srcf = argv[ 2 ];
  Tstring outf = argv[ 3 ];
  St00SinglePixelInterface spi( drkf, srcf );
  St00SinglePixelList spl = spi.GetSinglePixelList();
  Tofstream ofs;
  ofs.open( outf.c_str() );
  for ( Tsize_t i = 0; i < spl.size(); i ++ ) {
    signal.Fill( spl[ i ].GetSignal() );
    dark.Fill( spl[ i ].GetDark() );
    rms.Fill( spl[ i ].GetRms() );
    ofs << spl[ i ] << Tendl;
  }
  ofs.close();


  cv.cd( 1 );
  signal.Draw();
  cv.cd( 2 );
  dark.Draw();
  cv.cd( 3 );
  rms.Draw();



  ////////////////////////////////////////////////////////////////
  Tstring outext = ".dat";
  Tstring os = outf.erase( outf.rfind( outext ), outext.size() );
  Tstring psfile = os + ".ps";
  Tstring macrofile = os + ".C";
  cv.Print( psfile.c_str() );
  cv.Print( macrofile.c_str() );
  ////////////////////////////////////////////////////////////////


  theApplication -> Terminate();

  return( 0 );
}
