// =====================================================================
//  $Id: St00Map.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "St00Map.hh"

// 264276(եƥΰ256x256)
// 576ԥ뤴Ȥ˥ƥ륷եȤȯ
static const Tstring _rcfile = "setenvrc";

St00Map::St00Map( const Tstring& filename )
  : theEnvironmentVariableTable( _rcfile ),
    theNumberOfHorizontalPixels( theEnvironmentVariableTable.GetIntegerValue( "ST00_HPIXEL" ) ),
    theNumberOfVerticalPixels( theEnvironmentVariableTable.GetIntegerValue( "ST00_VPIXEL" ) ),
    theRateOfVerticalShift( theEnvironmentVariableTable.GetIntegerValue( "ST00_VSHIFT_CYCLE" ) ),
    theNumberOfHorizontalOverClockPixels( theEnvironmentVariableTable.GetIntegerValue( "ST00_HOC_PIXEL" ) ),
    theInputFileName( filename ),
    theHOCbuffer( 0.0 ),
    theMap( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 )
{;}

St00Map::~St00Map()
{;}

Tpixel_t St00Map::IsThisPixel( Tint dataid ) const
{
  if ( dataid > theRateOfVerticalShift * theNumberOfVerticalPixels + theNumberOfHorizontalOverClockPixels ) {
    return( tIgnore );
  }

  Tint colid = dataid % theRateOfVerticalShift;
  if ( colid < theNumberOfHorizontalPixels ) {
    return( tEffective );
  } else if ( colid < theNumberOfHorizontalPixels + theNumberOfHorizontalOverClockPixels - 1 ) {
    return( tHoc );
  } else if ( colid == theNumberOfHorizontalPixels + theNumberOfHorizontalOverClockPixels - 1 ) {
    return( tEndOfHoc );
  } else {
    return( tIgnore );
  }
}

Tvoid St00Map::FillMap( Tshort* data, Tint ndata )
{
  for ( Tint i = 0; i < ndata; i ++ ) {
    Tpixel_t pt = IsThisPixel( i );
    if ( pt == tIgnore ) {
      continue;
    } else if ( pt == tEffective ) {
      Tint colid = i % theRateOfVerticalShift;
      Tint rowid = i / theRateOfVerticalShift;
      theMap[ rowid ][ colid ] = (Tdouble)data[ i ];
    } else if ( pt == tHoc ) {
      theHOCbuffer += data[ i ];
      //Tcout << "DEBUG: : " << data[ i ] << Tendl;
    } else if ( pt == tEndOfHoc ) {
      theHOCbuffer += data[ i ];
      Tdouble ave = theHOCbuffer / theNumberOfHorizontalOverClockPixels;
      Tint rowid = i / theRateOfVerticalShift;
      for ( Tint col = 0; col < theNumberOfHorizontalPixels; col ++ ) {
	theMap[ rowid ][ col ] -= ave;
      }
      theHOCbuffer = 0.0;
    }
  }
  return;
}
